/*$Id: m_cpoly.h,v 14.19 1999/08/18 17:17:11 al Exp $ -*- C++ -*-
 * structs for fixed order polynomials, in 2 different forms
 * FPOLY is by function -- f0 = eval of function
 *			   f1 = 1st derivative
 *			   f2 = 2nd derivative
 *			   etc.
 * cpoly is by series -- c0 = coeff of x^0 term (constant)
 *			 c1 = coeff of x^1 term (1st derivative)
 *			 c2 = coeff of x^2 term
 *			 etc.
 */
#ifndef M_CPOLY_H
#define M_CPOLY_H
#include "io_trace.h"
/*--------------------------------------------------------------------------*/
struct FPOLY1;
struct CPOLY1;
/*--------------------------------------------------------------------------*/
struct FPOLY1{		/* first order polynomial	*/
  double   x;		/* the argument			*/
  double   f0;		/* the function (c0 + x*f1)	*/
  double   f1;		/* the first derivative		*/
  explicit FPOLY1(): x(0), f0(0), f1(0) {}
           FPOLY1(const FPOLY1& p): x(p.x), f0(p.f0), f1(p.f1){}
  explicit FPOLY1(double X,double F0,double F1): x(X), f0(F0), f1(F1) {}
  explicit FPOLY1(const CPOLY1& p);

  bool	   operator==(const FPOLY1& p)const
				{return (f1==p.f1 && f0==p.f0 && x==p.x);}
  FPOLY1&  operator*=(double s)	{f0*=s; f1*=s; return *this;}
  FPOLY1&  operator+=(const FPOLY1& s)
				{f0+=s.f0; f1+=s.f1; return *this;}
};
/*--------------------------------------------------------------------------*/
struct CPOLY1{		/* first order polynomial	*/
  double   x;		/* the argument			*/
  double   c0;		/* f(x) - x*f'(x), or f0 - x*f1 */
  double   c1;		/* the first derivative		*/
  explicit CPOLY1(): x(0), c0(0), c1(0) {}
  explicit CPOLY1(const CPOLY1& p): x(p.x), c0(p.c0), c1(p.c1){untested();}
  explicit CPOLY1(double X,double C0,double C1): x(X), c0(C0), c1(C1) {}
  explicit CPOLY1(const FPOLY1& p);

  bool	   operator==(const CPOLY1& p)const
			{untested(); return (c1==p.c1 && c0==p.c0 && x==p.x);}
  CPOLY1&  operator*=(double s)	{c0*=s; c1*=s; return *this;}
};
/*--------------------------------------------------------------------------*/
inline FPOLY1::FPOLY1(const CPOLY1& p)
  :x(p.x),
   f1(p.c1)
{
  f0 = p.c0 + p.x * p.c1;
}
/*--------------------------------------------------------------------------*/
inline CPOLY1::CPOLY1(const FPOLY1& p)
  :x(p.x),
   c1(p.f1)
{
  c0 = p.f0 - p.x * p.f1;      
}
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
#endif
