/*$Id: d_coil.h,v 15.11 1999/10/14 07:46:49 al Exp $ -*- C++ -*-
 * Inductance (L) component
 */
#ifndef D_COIL_H
#define D_COIL_H
#include "e_storag.h"
/*--------------------------------------------------------------------------*/
class DEV_INDUCTANCE : public STORAGE {
private:
  explicit DEV_INDUCTANCE(const DEV_INDUCTANCE& p) :STORAGE(p) {}
public:
  explicit DEV_INDUCTANCE()	:STORAGE() {}
private: // override virtual
  const char* dev_type()const	{return "inductor";}
  CARD*	   clone()const		{return new DEV_INDUCTANCE(*this);}
  //void   parse(CS&);		//ELEMENT
  //void   print(OMSTREAM,int)const; //ELEMENT
  //void   expand();		//CARD/nothing
  //void   precalc()		//STORAGE

  void	   dc_begin();
  void	   tr_begin();
  void	   tr_restore();
  //void   dc_advance();	//STORAGE
  //void   tr_advance();	//STORAGE
  bool     tr_needs_eval();
  void     tr_queue_eval();
  bool	   do_tr();
  void	   tr_load();
  double   tr_review();
  //void   tr_accept();		//CARD/nothing
  void	   tr_unload();
  //double tr_involts()const;	//ONEPORT

  void	    ac_begin();
  void	    do_ac();
  //COMPLEX ac_involts()const;	//ONEPORT
private:
  void		integrate();
};
/*--------------------------------------------------------------------------*/
class DEV_MUTUAL_L : public COMPONENT {
private:
  explicit	DEV_MUTUAL_L(const DEV_MUTUAL_L& p);
public:
  explicit	DEV_MUTUAL_L();
private: // override virtual
  const char* dev_type()const	{untested(); return "mutual_inductor";}
  bool	   is_2port()const	{untested(); return true;}
  CARD*	   clone()const		{untested(); return new DEV_MUTUAL_L(*this);}
  void	   parse(CS&);
  void	   print(OMSTREAM where, int detail)const;
  void	   expand();
  //void   precalc();		//CARD/nothing

  //void   dc_begin();		//CARD/nothing
  //void   tr_begin();		//CARD/nothing
  //void   tr_restore();	//CARD/nothing
  //void   dc_advance();	//CARD/nothing
  //void   tr_advance();	//CARD/nothing
  //bool   tr_needs_eval();	//CARD/nothing
  //void   tr_queue_eval();	//CARD/nothing
  //bool   do_tr();		//CARD/nothing
  //void   tr_load();		//CARD/nothing
  //double tr_review();		//CARD/nothing
  //void   tr_accept();		//CARD/nothing
  //void   tr_unload();		//CARD/nothing
  double   tr_involts()const
			{untested(); return dn_diff(n[IN1].v0(), n[IN2].v0());}

  //void   ac_begin();		//CARD/nothing
  //void   do_ac();		//CARD/nothing
  COMPLEX  ac_involts()const	{untested();return n[IN1].vac()-n[IN2].vac();}
private:
  std::string	_output_label;
  CARD*		_output;
  std::string	_input_label;
  CARD*		_input;
};
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
#endif
