/*$Id: ap_get.cc,v 15.19 1999/11/03 18:07:50 al Exp $ -*- C++ -*-
 * get value for matching keyword
 */
#include "md.h"
#include "ap.h"
/*--------------------------------------------------------------------------*/
//	CS&	CS::set(const std::string&, bool*, bool);
//	CS&	CS::set(const std::string&, int*, int);
//	CS&	CS::get(const std::string&, bool*, AP_MOD=mNONE);
//	CS&	CS::get(const std::string&, int*, AP_MOD=mNONE, int=0);
//	CS&	CS::get(const std::string&, double*, AP_MOD=mNONE, double=0);
//	CS&	CS::get(const std::string&, double*, double*);
/*--------------------------------------------------------------------------*/
CS& CS::set(const std::string& key, bool* val, bool newval)
{
  if (pmatch(key)){
    *val = newval;
  }
  return *this;
}
/*--------------------------------------------------------------------------*/
CS& CS::set(const std::string& key, int* val, int newval)
{
  if (pmatch(key)){
    *val = newval;
  }
  return *this;
}
/*--------------------------------------------------------------------------*/
CS& CS::get(const std::string& key, bool* val, AP_MOD m)
{
  assert(m==mNONE || m==mINVERT);
  std::string false_key("NO");
  false_key += key;

  {if (pmatch(key)){
    set("1", val, true)
      || set("0", val, false)
      || set("True", val, true)
      || set("False", val, false)
      || set("Yes", val, true)
      || set("No", val, false)
      || set("#True", val, true)
      || set("#False", val, false)
      || ::set(val, true);
    _ok = true;
    if (m==mINVERT){
      untested();
      *val = !*val;
    }
  }else if (pmatch(false_key)){
    *val = (m==mINVERT);
  }}
  return *this;
}
/*--------------------------------------------------------------------------*/
CS& CS::get(const std::string& key, int* val, AP_MOD mk1, int mv1)
{
  if (pmatch(key)){
    switch(mk1){
      case mNONE:		  *val = int(ctof());		break;
      case mSCALE:    untested(); *val = int(ctof()) * mv1;	break;
      case mOFFSET:   untested(); *val = int(ctof()) + mv1;	break;
      case mINVERT:   untested(); *val = 1 / int(ctof());	break;
      case mPOSITIVE: untested(); *val = abs(int(ctof()));	break;
      case mOCTAL:		  *val = ctoo();		break;
      case mHEX:      untested(); *val = ctox();		break;
    }
  }
  return *this;
}
/*--------------------------------------------------------------------------*/
CS& CS::get(const std::string& key, double* val, AP_MOD mk1, double mv1)
{
  if (pmatch(key)){
    *val = ctof();
    switch(mk1){
      case mNONE:		  /*nothing*/		break;
      case mSCALE:		  *val *= mv1;		break;
      case mOFFSET:   untested(); *val += mv1;		break;
      case mINVERT:   untested(); *val = 1 / *val;	break;
      case mPOSITIVE:		  *val = fabs(*val);	break;
      case mOCTAL:    unreachable();			break;
      case mHEX:      unreachable();			break;
    }
  }
  return *this;
}
/*--------------------------------------------------------------------------*/
CS& CS::get(const std::string& key, double* val1, double* val2)
{
  untested();
  if (pmatch(key)){
    *val1 = ctof();
    *val2 = ctof();
  }
  return *this;
}
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
