//  UDialog.cpp version 1.5
//  yudit package - Unicode Editor for the X Window System (and Linux) 
//
//  Author: gsinai@iname.com (Gaspar Sinai)
//  GNU Copyright (C) 1997,1998,1999  Gaspar Sinai
// 
//  yudit version 1.5  Copyright(C) 30 November, 1999, Tokyo Japan  Gaspar Sinai
//  yudit version 1.4  Copyright(C) 25 November, 1999, Tokyo Japan  Gaspar Sinai
//  yudit version 1.3  Copyright(C)  5 April,    1999, Tokyo Japan  Gaspar Sinai
//  yudit version 1.2  Copyright(C) 10 December, 1998, Tokyo Japan  Gaspar Sinai
//  yudit version 1.1  Copyright(C) 23 August,   1998, Tokyo Japan  Gaspar Sinai
//  yudit version 1.0  Copyright(C) 17 May,      1998, Tokyo Japan  Gaspar Sinai
//  yudit version 0.99 Copyright(C)  4 April,    1998, Tokyo Japan  Gaspar Sinai
//  yudit version 0.97 Copyright(C)  4 February, 1998, Tokyo Japan  Gaspar Sinai
//  yudit version 0.95 Copyright(C) 10 January,  1998, Tokyo Japan  Gaspar Sinai
//  yudit version 0.94 Copyright(C) 17 December, 1997, Tokyo Japan  Gaspar Sinai
//  yudit version 0.9 Copyright (C)  8 December, 1997, Tokyo Japan  Gaspar Sinai
//  yutex version 0.8 Copyright (C)  5 November, 1997, Tokyo Japan  Gaspar Sinai
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//

#include "UDialog.h"

UDialog::UDialog (UShell* transient_, int frameSize_) :
	UShell ((UTop*)transient_->top, transient_, frameSize_)
	
{
	realParent = transient_;
}

UDialog::UDialog (UTop* top_, int frameSize_) :
	UShell (top_, (UShell*) 0 , frameSize_)
	
{
	realParent = 0;
}

UDialog::~UDialog ()
{
}

void
UDialog::quit ()
{
}

UDialog::UValue
UDialog::getValue ()
{
	UEvent		event;
	UBestSize	bs;
	XRectangle	rect;

	bs = getBestSize ();
	rectangle.width = bs.width;
	rectangle.height = bs.height;
	XResizeWindow (top->display, window, bs.width, bs.height);
	resize (bs.width, bs.height);

	if (realParent!=0)
	{
		rect = realParent->rectangle;
		if (rect.x + 40 + (rect.width+bs.width)/2
		    >  XDisplayWidth (top->display, top->screen))
		{
			rect.x-= rect.x + (rect.width+bs.width)/2 +40  -
				XDisplayWidth (top->display, top->screen);
		}
		if (rect.y + 40 + (rect.height+bs.height)/2
		    >  XDisplayHeight (top->display, top->screen))
		{
			rect.y-= rect.y + (rect.height+bs.height)/2 +40 - 
				XDisplayHeight (top->display, top->screen);
		}
	}
	else
	{
		rect.x = 0; rect.y = 0;
		rect.width = XDisplayWidth (top->display, top->screen);
		rect.height = XDisplayHeight (top->display, top->screen);
	}
	
	// center
	move (rect.x+ (rect.width-bs.width)/2, 
	    rect.y +  (rect.height-bs.height)/2); 

	show ();
	XUngrabPointer (top->display, CurrentTime);
	XFlush (top->display);
	while (XPending (top->display) !=0)
	{
		UNextEvent (top, &event);
		passEvent (&event);
		//UDispatchEvent (top, &event);
	}
	while (shown)
	{
		UNextEvent (top, &event);
		passEvent (&event);
	}
	XFlush (top->display);
	return CANCEL;
}

void
UDialog::passEvent (UEvent* event)
{
	switch (event->type)
	{
	case UEvent::X:
		switch (event->xevent.type)
		{
		case KeyPress:
		case ButtonRelease:
		case ButtonPress:
		case KeyRelease:
		case MotionNotify:
			if (isChild (event->xevent.xany.window))
			{
				UDispatchEvent (top, event);
			}
			break;
		case ClientMessage:
			if (event->xevent.xclient.message_type 
				==  top->wmProtocols
			    && event->xevent.xclient.data.l[0] 
				==  top->wmDeleteWindow
			    && event->xevent.xclient.format == 32)
			{
				if (isChild (event->xevent.xany.window))
				{
					hide ();
					return;
				}
			}
			else
			{
				UDispatchEvent (top, event);
			}
			break;
		default:
			UDispatchEvent (top, event);
			break;
		}
		break;
	default:
		UDispatchEvent (top, event);
		break;
	}
}
