/************************************************************************/
/*  Dialog with document properties.					*/
/************************************************************************/

#   include	"config.h"

#   include	<stdlib.h>
#   include	<stdio.h>
#   include	<debugon.h>

#   include	<X11/Xatom.h>
#   include	<X11/IntrinsicP.h>
#   include	<Xm/Text.h>
#   include	<Xm/DialogS.h>
#   include	<Xm/MainW.h>
#   include	<Xm/Form.h>
#   include	<Xm/Label.h>
#   include	<Xm/Frame.h>
#   include	<Xm/DrawingA.h>
#   include	<Xm/ToggleB.h>
#   include	<Xm/RowColumn.h>

#   include	"tedApp.h"

#   include	"appUtil.h"

#   define	DRH_CM	4.5

/************************************************************************/
/*  Represents a mail dialog.						*/
/************************************************************************/
#   define	FILEL	400

typedef struct PropertyDialog
    {
    Widget			dpdTopWidget;
    Widget			dpdDialog;

    Widget			dpdOkButton;

    char *			dpdOkText;
    char *			dpdCancelText;

    char *			dpdTitleText;
    char *			dpdAuthorText;
    char *			dpdSubjectText;
    char *			dpdKeywordsText;
    char *			dpdCommentText;

    Widget			dpdTitleWidget;
    Widget			dpdAuthorWidget;
    Widget			dpdSubjectWidget;
    Widget			dpdKeywordsWidget;
    Widget			dpdCommentWidget;

    int				dpdResponse;
    } PropertyDialog;

static PropertyDialog *	TED_PropertyDialog;

# define xx(x)	x,x

static XtResource TED_PropertyDialogResourceTable[]=
    {
	{ xx("propDialogTitle"), XtRString, sizeof(char *),
		    offsetof(PropertyDialog,dpdTitleText),
		    XtRString, "Title" },
	{ xx("propDialogAuthor"), XtRString, sizeof(char *),
		    offsetof(PropertyDialog,dpdAuthorText),
		    XtRString, "Author" },
	{ xx("propDialogSubject"), XtRString, sizeof(char *),
		    offsetof(PropertyDialog,dpdSubjectText),
		    XtRString, "Subject" },
	{ xx("propDialogKeywords"), XtRString, sizeof(char *),
		    offsetof(PropertyDialog,dpdKeywordsText),
		    XtRString, "Keywords" },
	{ xx("propDialogComment"), XtRString, sizeof(char *),
		    offsetof(PropertyDialog,dpdCommentText),
		    XtRString, "Comment" },

	{ xx("propDialogCancel"), XtRString, sizeof(char *),
		    offsetof(PropertyDialog,dpdCancelText),
		    XtRString, "Cancel" },
	{ xx("propDialogOk"), XtRString, sizeof(char *),
		    offsetof(PropertyDialog,dpdOkText),
		    XtRString, "Ok" },
    };

/************************************************************************/
/*									*/
/*  One of the Text widgets changed.					*/
/*									*/
/************************************************************************/

static void tedPropertyChanged(	Widget		w,
				XtPointer	voiddpd,
				XtPointer	call_data )
    {
    PropertyDialog *	dpd= (PropertyDialog *)voiddpd;

    XtSetSensitive( dpd->dpdOkButton, True );

    XtVaSetValues( dpd->dpdDialog,
		    XmNdefaultButton,	dpd->dpdOkButton,
		    NULL );
    return;
    }

/************************************************************************/
/*									*/
/*  The buttons have been pushed.					*/
/*									*/
/************************************************************************/

static void tedPropertiesCancelPushed(	Widget		w,
					XtPointer	voiddpd,
					XtPointer	voidpbcs	 )
    {
    PropertyDialog *	dpd= (PropertyDialog *)voiddpd;

    dpd->dpdResponse= AQDrespCANCEL;

    return;
    }

static void tedPropertiesOkPushed(	Widget		w,
					XtPointer	voiddpd,
					XtPointer	voidpbcs	 )
    {
    PropertyDialog *	dpd= (PropertyDialog *)voiddpd;

    dpd->dpdResponse= AQDrespOK;

    return;
    }

/************************************************************************/
/*  A find tool must be destroyed.					*/
/************************************************************************/
static void tedClosePropertyDialog(	Widget		w,
					XtPointer	voiddpd,
					XtPointer	voidlcs	 )
    {
    PropertyDialog *	dpd= (PropertyDialog *)voiddpd;

    dpd->dpdResponse= AQDrespCANCEL;

    return;
    }

static Widget appMailDialogMakeTextForm(	Widget		parent,
						Display *	display,
						PropertyDialog *	dpd )
    {
    Widget		columns;
    Widget		labelColumn;
    Widget		textColumn;

    Widget		label;

    appMakeLabelAndTextColumns( &labelColumn, &textColumn, &columns, parent );

    appMakeColumnLabel( &label, labelColumn, dpd->dpdTitleText );
    appMakeColumnLabel( &label, labelColumn, dpd->dpdAuthorText );
    appMakeColumnLabel( &label, labelColumn, dpd->dpdSubjectText );
    appMakeColumnLabel( &label, labelColumn, dpd->dpdKeywordsText );
    appMakeColumnLabel( &label, labelColumn, dpd->dpdCommentText );

    appMakeColumnText( &(dpd->dpdTitleWidget), textColumn, 60, True );
    appMakeColumnText( &(dpd->dpdAuthorWidget), textColumn, 60, True );
    appMakeColumnText( &(dpd->dpdSubjectWidget), textColumn, 60, True );
    appMakeColumnText( &(dpd->dpdKeywordsWidget), textColumn, 60, True );
    appMakeColumnText( &(dpd->dpdCommentWidget), textColumn, 60, True );

    XtAddCallback( dpd->dpdTitleWidget, XmNvalueChangedCallback,
					    tedPropertyChanged, (void *)dpd );
    XtAddCallback( dpd->dpdAuthorWidget, XmNvalueChangedCallback,
					    tedPropertyChanged, (void *)dpd );
    XtAddCallback( dpd->dpdSubjectWidget, XmNvalueChangedCallback,
					    tedPropertyChanged, (void *)dpd );
    XtAddCallback( dpd->dpdKeywordsWidget, XmNvalueChangedCallback,
					    tedPropertyChanged, (void *)dpd );
    XtAddCallback( dpd->dpdCommentWidget, XmNvalueChangedCallback,
					    tedPropertyChanged, (void *)dpd );

    XtManageChild( labelColumn );
    XtManageChild( textColumn );
    XtManageChild( columns );

    return columns;
    }

/************************************************************************/
/*									*/
/*  Make the form with the two buttons.					*/
/*									*/
/************************************************************************/

static Widget appMailDialogMakeButtonRow( Widget		parent,
					PropertyDialog *	dpd )
    {
    Widget	row;
    Widget	cancelButton;

    row= appMakeButtonRow( parent, 2 );

    /**********************/

    dpd->dpdOkButton= appMakeRowButton( row, dpd->dpdOkText,
				tedPropertiesOkPushed, (void *)dpd, 0, True );

    /**********************/

    cancelButton= appMakeRowButton( row, dpd->dpdCancelText, 
			    tedPropertiesCancelPushed, (void *)dpd, 1, False );

    XtVaSetValues( dpd->dpdDialog,
			XmNcancelButton,	cancelButton,
			NULL );

    /**********************/

    XtManageChild( dpd->dpdOkButton );
    XtManageChild( cancelButton );

    XtManageChild( row );

    return row;
    }

/************************************************************************/
/*									*/
/*  Make a document properties dialog.					*/
/*									*/
/************************************************************************/

static PropertyDialog * tedMakePropertyDialog(	EditApplication *	ea,
					EditDocument *		ed,
					Widget			printOption,
					const char *		pixmapName )
    {
    Display *		display= XtDisplay( printOption );
    PropertyDialog *	dpd;
    
    Widget		paned;
    Widget		textForm;
    Widget		buttonForm;

    const int		withSeparator= 0;
    Pixmap		iconPixmap= (Pixmap)0;

    if  ( appGetImagePixmap( ea, pixmapName, &iconPixmap )  )
	{ SDEB(pixmapName); return (PropertyDialog *)0;	}

    dpd= (PropertyDialog *)malloc( sizeof(PropertyDialog) );
    if  ( ! dpd )
	{ XDEB(dpd); return (PropertyDialog *)0;	}

    XtGetApplicationResources( ea->eaTopWidget, dpd,
				    TED_PropertyDialogResourceTable,
				    XtNumber(TED_PropertyDialogResourceTable),
				    NULL, 0 );

    appMakeVerticalDialog( &(dpd->dpdTopWidget), &(dpd->dpdDialog),
			    &paned, ea, tedClosePropertyDialog, (void *)dpd,
			    iconPixmap, withSeparator, "tedPropertyDialog" );

    appSetShellTitle( dpd->dpdTopWidget, printOption, ea->eaApplicationName );


    textForm= appMailDialogMakeTextForm( paned, display, dpd );

    buttonForm= appMailDialogMakeButtonRow( paned, dpd );

    XtManageChild( paned );

    appSetRelativeCallback( ed->edTopWidget, dpd->dpdDialog );

    XtManageChild( dpd->dpdDialog );

    appSetFocusCallback( dpd->dpdDialog );

    XtManageChild( dpd->dpdDialog );

    appDialogRelative( ed->edTopWidget, dpd->dpdDialog );

    return dpd;
    }

/************************************************************************/

static int tedPropChangeProperty(	int *			pChanged,
					unsigned char **	pValue,
					Widget			textWidget )
    {
    char *	oldValue= (char *)*pValue;
    char *	newValue;
    char *	saved= (char *)0;

    newValue= XmTextGetString( textWidget );

    if  ( ! oldValue || ! oldValue[0] )
	{
	if  ( ! newValue[0] )
	    { XtFree( newValue ); return 0;	}
	}
    else{
	if  ( ! strcmp( oldValue, newValue ) )
	    { XtFree( newValue ); return 0;	}
	}

    if  ( newValue[0] )
	{
	saved= strdup( newValue );
	if  ( ! saved )
	    { XDEB(saved); return -1;	}
	}

    XtFree( newValue );

    if  ( oldValue )
	{ free( oldValue );	}

    *pChanged= 1; *pValue= (unsigned char *)saved;

    return 0;
    }

/************************************************************************/
/*									*/
/*  Show the 'Send...' dialog.						*/
/*									*/
/*  1)	Make or just show it.						*/
/*  2)	Set the default content.					*/
/*									*/
/************************************************************************/

int tedRunPropertyDialog(		EditApplication *	ea,
					EditDocument *		ed,
					Widget			option,
					const char *		pixmapName )
    {
    int				rval= 0;
    int				changed= 0;

    PropertyDialog *		dpd= TED_PropertyDialog;

    TedDocument *		td= (TedDocument *)ed->edPrivateData;
    BufferDocument *		bd= td->tdDocument;

    /*  1  */
    if  ( ! dpd )
	{
	dpd= TED_PropertyDialog= tedMakePropertyDialog( ea, ed, option,
								pixmapName );
	if  ( ! dpd )
	    { XDEB(dpd); return -1;	}

	}
    else{
	appSetShellTitle( dpd->dpdTopWidget, option, ea->eaApplicationName );

	appSetRelativeCallback( ed->edTopWidget, dpd->dpdDialog );
	appDialogRelative( ed->edTopWidget, dpd->dpdDialog );

	appSetFocusCallback( dpd->dpdDialog );

	XtManageChild( dpd->dpdDialog );
	}

    if  ( bd->bdTitle )
	{ XmTextSetString( dpd->dpdTitleWidget, (char *)bd->bdTitle );	}
    else{ XmTextSetString( dpd->dpdTitleWidget, "" );		}

    if  ( bd->bdAuthor )
	{ XmTextSetString( dpd->dpdAuthorWidget, (char *)bd->bdAuthor ); }
    else{ XmTextSetString( dpd->dpdAuthorWidget, "" );			}

    if  ( bd->bdSubject )
	{
	XmTextSetString( dpd->dpdSubjectWidget, (char *)bd->bdSubject );
	}
    else{ XmTextSetString( dpd->dpdSubjectWidget, "" );		}

    if  ( bd->bdKeywords )
	{
	XmTextSetString( dpd->dpdKeywordsWidget, (char *)bd->bdKeywords );
	}
    else{ XmTextSetString( dpd->dpdKeywordsWidget, "" );		}

    if  ( bd->bdComment )
	{
	XmTextSetString( dpd->dpdCommentWidget, (char *)bd->bdComment );
	}
    else{ XmTextSetString( dpd->dpdCommentWidget, "" );		}

    XtSetSensitive( dpd->dpdOkButton, False );

    dpd->dpdResponse= AQDrespNONE;

    while( dpd->dpdResponse == AQDrespNONE )
	{ XtAppProcessEvent( ea->eaContext, XtIMAll ); }

    switch( dpd->dpdResponse )
	{
	case AQDrespOK:
	    break;
	default:
	    LDEB(dpd->dpdResponse);
	    /*FALLTHROUGH*/
	case AQDrespCANCEL:
	    XtUnmanageChild( dpd->dpdDialog );
	    return -1;
	}

    XtUnmanageChild( dpd->dpdDialog );

    if  ( tedPropChangeProperty( &changed, &bd->bdTitle,
						dpd->dpdTitleWidget ) )
	{ LDEB(1); return -1;	}

    if  ( tedPropChangeProperty( &changed, &bd->bdAuthor,
						dpd->dpdAuthorWidget ) )
	{ LDEB(1); return -1;	}

    if  ( tedPropChangeProperty( &changed, &bd->bdSubject,
						dpd->dpdSubjectWidget ) )
	{ LDEB(1); return -1;	}

    if  ( tedPropChangeProperty( &changed, &bd->bdKeywords,
						dpd->dpdKeywordsWidget ) )
	{ LDEB(1); return -1;	}

    if  ( tedPropChangeProperty( &changed, &bd->bdComment,
						dpd->dpdCommentWidget ) )
	{ LDEB(1); return -1;	}

    if  ( changed )
	{ appDocumentChanged( ea, ed, 1 ); }

    return rval;
    }
