/************************************************************************/
/*  Ted, main module.							*/
/************************************************************************/

#   include	"config.h"

#   include	<stddef.h>
#   include	<stdlib.h>
#   include	<stdio.h>
#   include	<ctype.h>

#   include	"tedApp.h"
#   include	<appUtil.h>

#   include	<sioXprop.h>

#   include	<debugon.h>

/************************************************************************/
/*									*/
/*  Edit menu actions.							*/
/*									*/
/*  2)  If the beginning of the selection is the beginning of a		*/
/*	kyperlink, try to include the link.				*/
/*  8)  Also put a copied picture on the clipboard that 'xv' implements	*/
/*	on the root window.						*/
/*									*/
/************************************************************************/

static void tedFinishTextCopy(	TedDocument *		td,
				const BufferSelection *	bs )
    {
    td->tdCopiedSelectionClosed= 1;

    if  ( (unsigned)bs->bsEnd.bpStroff < bs->bsEnd.bpBi->biParaStrlen )
	{ td->tdCopiedSelectionClosed= 0;	}

    if  ( bs->bsBegin.bpBi == bs->bsEnd.bpBi		&&
	  bs->bsBegin.bpLine == bs->bsEnd.bpLine	)
	{ td->tdCopiedSelectionClosed= 0;	}

    appCleanBitmapImage( &(td->tdCopiedImage) );
    appInitBitmapImage( &(td->tdCopiedImage) );

    return;
    }

static int tedDocCopySelection(	EditDocument *	ed,
				XEvent *	event )
    {
    EditApplication *		ea= ed->edApplication;
    TedDocument *		td= (TedDocument *)ed->edPrivateData;

    BufferItem *		bi;
    TextLine *			tl;
    TextParticule *		tp;
    InsertedObject *		io;

    SimpleOutputStream *	sos;

    BufferSelection		bsNew= td->tdSelection;
    const int			saveBookmarks= 0;

    int				startPart;
    int				endPart;

    const char *		fileName= (const char *)0;
    int				fileSize= 0;
    const char *		markName= (const char *)0;
    int				markSize= 0;

    if  ( ! tedHasSelection( td ) || tedHasIBarSelection( td ) )
	{ return -1; }

    /*  2  */
    if  ( ! docGetHyperlinkForPosition( &(bsNew.bsBegin),
				&startPart, &endPart,
				&fileName, &fileSize, &markName, &markSize ) )
	{
	bi= bsNew.bsBegin.bpBi;
	tp= bi->biParaParticules+ bsNew.bsBegin.bpParticule;

	if  ( startPart < bsNew.bsBegin.bpParticule			&&
	      bi->biParaParticules[startPart].tpStroff == tp->tpStroff	)
	    { bsNew.bsBegin.bpParticule= startPart;	}

	if  ( bsNew.bsEnd.bpBi == bi )
	    {
	    tp= bi->biParaParticules+ bsNew.bsEnd.bpParticule;

	    if  ( endPart > bsNew.bsEnd.bpParticule			&&
		  bi->biParaParticules[endPart].tpStroff == tp->tpStroff )
		{ bsNew.bsEnd.bpParticule= endPart;	}
	    }
	}

    sos= sioOutMemoryOpen( &(td->tdCopiedSelection) );
    if  ( ! sos )
	{ XDEB(sos); return -1;    }

    if  ( docRtfSaveDocument( sos, td->tdDocument, &bsNew, saveBookmarks ) )
	{ LDEB(1); sioOutClose( sos ); return -1;	}

    if  ( sioOutClose( sos ) )
	{ LDEB(1); return -1;	}

    tedFinishTextCopy( td, &bsNew );

    if  ( ! tedGetObjectSelection( td, &bi, &tl, &tp, &io ) )
	{
	if  ( tedSaveObjectPicture( &(td->tdCopiedImage), io ) )
	    { LDEB(io->ioKind); return -1;	}

	if  ( appDocOwnSelection( ed, "PRIMARY",
			TedPrimaryPictureTargets, TedPrimaryPictureTargetCount,
			event->xbutton.time ) )
	    { LDEB(1); return -1;	}

	/*  8  */
	if  ( appImgPutXvClipboard( &(td->tdCopiedImage.abiBitmap),
		    td->tdCopiedImage.abiBuffer, ea->eaDisplay, ea->eaScreen ) )
	    { LDEB(1);	}
	}
    else{
	if  ( appDocOwnSelection( ed, "PRIMARY",
			TedPrimaryTextTargets, TedPrimaryTextTargetCount,
			event->xbutton.time ) )
	    { LDEB(1); return -1;	}
	}

    return 0;
    }

/************************************************************************/
/*									*/
/*  Copy a part of the document, in practice, a bookmark as a link	*/
/*									*/
/************************************************************************/

int tedCopyAsLink(	EditDocument *		ed,
			const BufferItem *	bi,
			const BufferSelection *	bs,
			const char *		fileName,
			const char *		markName,
			int			markSize,
			XEvent *		event )
    {
    SimpleOutputStream *	sos;
    TedDocument *		td= (TedDocument *)ed->edPrivateData;

    int				fileSize= 0;

    if  ( fileName )
	{ fileSize= strlen( fileName );	}

    sos= sioOutMemoryOpen( &(td->tdCopiedSelection) );
    if  ( ! sos )
	{ XDEB(sos); return -1;    }

    if  ( docRtfSaveSelectionAsLink( sos, td->tdDocument, bs,
				    fileName, fileSize, markName, markSize ) )
	{ LDEB(1); sioOutClose( sos ); return -1;	}

    if  ( sioOutClose( sos ) )
	{ LDEB(1); return -1;	}

    tedFinishTextCopy( td, bs );

    if  ( appDocOwnSelection( ed, "PRIMARY",
		    TedPrimaryTextTargets, TedPrimaryTextTargetCount,
		    event->xbutton.time ) )
	{ LDEB(1); return -1;	}

    return 0;
    }

void tedDocCut(			EditDocument *	ed,
				XEvent *	event	)
    {
    TedDocument *		td= (TedDocument *)ed->edPrivateData;

    if  ( ! td->tdCanReplaceSelection )
	{ LDEB(td->tdCanReplaceSelection); return;	}

    if  ( tedDocCopySelection( ed, event ) )
	{ LDEB(1); return;	}

    tedAppReplaceSelection( ed, (const unsigned char *)0, 0 );

    return;
    }

void tedDocCopy(		EditDocument *	ed,
				XEvent *	event	)
    {
    TedDocument *		td= (TedDocument *)ed->edPrivateData;

    if  ( tedDocCopySelection( ed, event ) )
	{ return;	}

    td->tdVisibleSelectionCopied= 1;

    tedExposeSelection( ed, &(td->tdSelection), /*scrolledX,Y*/ 0,0 );

    return;
    }

/************************************************************************/
/*									*/
/*  Ted, Copy/Paste functionality.					*/
/*									*/
/************************************************************************/

void tedPrimaryLost(	Widget				w,
			EditDocument *			ed,
			XSelectionClearEvent *		clrEvent )
    {
    TedDocument *		td= (TedDocument *)ed->edPrivateData;

    td->tdVisibleSelectionCopied= 0;

    if  ( tedHasSelection( td ) && ! tedHasIBarSelection( td ) )
	{
	tedExposeSelection( ed, &(td->tdSelection), /*scrolledX,Y*/ 0,0 );
	}
    }

/************************************************************************/
/*									*/
/*  Return the selection to a requestor.				*/
/*									*/
/************************************************************************/

int tedCopyPrimaryRtf(	Widget				w,
			EditDocument *			ed,
			Window				requestor,
			Atom				property,
			Atom				target )
    {
    Display *			display= XtDisplay( w );
    TedDocument *		td= (TedDocument *)ed->edPrivateData;

    SimpleOutputStream *	sos;

    if  ( td->tdCopiedSelection.mbCapacity == 0 )
	{ LDEB(td->tdCopiedSelection.mbCapacity); return -1; }

    sos= sioOutXpropOpen( display, requestor, property, target );
    if  ( ! sos )
	{ XDEB(sos); return -1;	}

    if  ( sioOutWriteBytes( sos, td->tdCopiedSelection.mbBytes,
				    td->tdCopiedSelection.mbCapacity ) <= 0 )
	{ LDEB(1); sioOutClose( sos ); return -1;	}

    sioOutClose( sos );

#   if 0
    sos= sioOutStdioOpen( "/tmp/copied.rtf" );
    if  ( sioOutWriteBytes( sos, td->tdCopiedSelection.mbBytes,
				    td->tdCopiedSelection.mbCapacity ) <= 0 )
	{ LDEB(1); sioOutClose( sos ); return -1;	}
    sioOutClose( sos );
#   endif

    return 0;
    }

int tedCopyPrimaryString(	Widget				w,
				EditDocument *			ed,
				Window				requestor,
				Atom				property,
				Atom				target )
    {
    Display *			display= XtDisplay( w );
    TedDocument *		td= (TedDocument *)ed->edPrivateData;

    SimpleOutputStream *	sos;

    BufferDocument *		bd;
    SimpleInputStream *		sis;
    int				res;

    if  ( td->tdCopiedSelection.mbCapacity == 0 )
	{ LDEB(td->tdCopiedSelection.mbCapacity); return -1; }

    sos= sioOutXpropOpen( display, requestor, property, target );
    if  ( ! sos )
	{ XDEB(sos); return -1;	}

    sis= sioInMemoryOpen( &td->tdCopiedSelection );
    if  ( ! sis )
	{ XDEB(sis); sioOutClose( sos ); return -1;	}

    bd= docRtfReadFile( sis );

    sioInClose( sis );

    if  ( ! bd )
	{ XDEB(bd); sioOutClose( sos ); return -1; }

    res= docPlainSaveDocument( sos, bd, (BufferSelection *)0,
					0, td->tdCopiedSelectionClosed );

    docFreeDocument( bd );

    if  ( res )
	{ LDEB(res); sioOutClose( sos ); return -1; }

    sioOutClose( sos );

    return 0;
    }

int tedCopyPrimaryPng(	Widget				w,
			EditDocument *			ed,
			Window				requestor,
			Atom				property,
			Atom				target )
    {
    Display *			display= XtDisplay( w );
    TedDocument *		td= (TedDocument *)ed->edPrivateData;

    SimpleOutputStream *	sos;

    if  ( ! td->tdCopiedImage.abiBuffer )
	{ XDEB(td->tdCopiedImage.abiBuffer); return -1;	}

    sos= sioOutXpropOpen( display, requestor, property, target );
    if  ( ! sos )
	{ XDEB(sos); return -1;	}

    if  ( bmPngWritePng( &(td->tdCopiedImage.abiBitmap),
					    td->tdCopiedImage.abiBuffer, sos ) )
	{ LDEB(1); sioOutClose( sos ); return -1;	}

    sioOutClose( sos );

    return 0;
    }

int tedCopyPrimaryPixmap(	Widget				w,
				EditDocument *			ed,
				Window				requestor,
				Atom				property,
				Atom				target )
    {
    Display *		display= XtDisplay( w );
    int			screen= DefaultScreen( display );
    TedDocument *	td= (TedDocument *)ed->edPrivateData;

    Pixmap		pixmapCopied;

    int			wide= td->tdCopiedImage.abiBitmap.bdPixelsWide;
    int			high= td->tdCopiedImage.abiBitmap.bdPixelsHigh;

    if  ( appImgMakePixmap( display, screen, requestor, ed->edGc,
			    &pixmapCopied, wide, high,
			    &(ed->edColors), &(td->tdCopiedImage) ) )
	{
	LDEB(target);
	appCleanBitmapImage( &(td->tdCopiedImage) );
	appInitBitmapImage( &(td->tdCopiedImage) );
	return -1;
	}

    XChangeProperty( display, requestor, property, target,
			8* sizeof(Pixmap), PropModeReplace,
			(unsigned char *)&pixmapCopied,
			1 );

    return 0;
    }

int tedCopyFontTed(	Widget				w,
			EditDocument *			ed,
			Window				requestor,
			Atom				property,
			Atom				target )
    {
    Display *			display= XtDisplay( w );
    TedDocument *		td= (TedDocument *)ed->edPrivateData;

    SimpleOutputStream *	sos;

    if  ( td->tdCopiedFont.mbCapacity == 0 )
	{ LDEB(td->tdCopiedFont.mbCapacity); return -1; }

    sos= sioOutXpropOpen( display, requestor, property, target );
    if  ( ! sos )
	{ XDEB(sos); return -1;	}

    if  ( sioOutWriteBytes( sos, td->tdCopiedFont.mbBytes,
					td->tdCopiedFont.mbCapacity ) <= 0 )
	{ LDEB(1); sioOutClose( sos ); return -1;	}

    sioOutClose( sos );

    return 0;
    }

int tedCopyRulerTed(	Widget				w,
			EditDocument *			ed,
			Window				requestor,
			Atom				property,
			Atom				target )
    {
    Display *			display= XtDisplay( w );
    TedDocument *		td= (TedDocument *)ed->edPrivateData;

    SimpleOutputStream *	sos;

    if  ( td->tdCopiedRuler.mbCapacity == 0 )
	{ LDEB(td->tdCopiedRuler.mbCapacity); return -1; }

    sos= sioOutXpropOpen( display, requestor, property, target );
    if  ( ! sos )
	{ XDEB(sos); return -1;	}

    if  ( sioOutWriteBytes( sos, td->tdCopiedRuler.mbBytes,
					td->tdCopiedRuler.mbCapacity ) <= 0 )
	{ LDEB(1); sioOutClose( sos ); return -1;	}

    sioOutClose( sos );

    return 0;
    }

/************************************************************************/
/*									*/
/*  Finish a paste action.						*/
/*									*/
/************************************************************************/
typedef BufferDocument *	(*TED_READ) (	SimpleInputStream * sis );

typedef int	(*TED_INCLUDE) (	Widget			w,
					EditDocument *		ed,
					BufferDocument *	bd );

static void tedPastePrimaryGeneric(	Widget			w,
					EditDocument *		ed,
					XSelectionEvent *	selEvent,
					TED_READ		readDoc,
					TED_INCLUDE		includeDoc )
    {
    Display *			display= XtDisplay( w );
    Window			win= XtWindow( w );

    SimpleInputStream *		sis;

    BufferDocument *		bd;

    sis= sioInXpropOpen( display, win, selEvent->property );
    if  ( ! sis )
	{ XDEB(sis); return;	}

    bd= (*readDoc)( sis );

    sioInXpropEraseAndClose( sis );

    if  ( ! bd )
	{ XDEB( bd ); return; }

    if  ( (*includeDoc)( w, ed, bd ) )
	{ LDEB(1); docFreeDocument( bd ); return;	}

    docFreeDocument( bd );

    appDocumentChanged( ed->edApplication, ed, 1 );

    return;
    }

void tedPastePrimaryRtf(		Widget			w,
					EditDocument *		ed,
					XSelectionEvent *	selEvent )
    {
    tedPastePrimaryGeneric( w, ed, selEvent,
				    docRtfReadFile, tedIncludeRtfDocument );
    }

void tedPastePrimaryString(		Widget			w,
					EditDocument *		ed,
					XSelectionEvent *	selEvent )
    {
    tedPastePrimaryGeneric( w, ed, selEvent,
				    docPlainReadFile, tedIncludePlainDocument );
    }

void tedPastePrimaryPng(		Widget			w,
					EditDocument *		ed,
					XSelectionEvent *	selEvent )
    {
    TedDocument *	td= (TedDocument *)ed->edPrivateData;

    Display *		display= XtDisplay( w );
    Window		win= XtWindow( w );

    SimpleInputStream *	sis;

    AppBitmapImage *	abi;

    if  ( ! td->tdCanReplaceSelection )
	{ LDEB(td->tdCanReplaceSelection); return;	}

    abi= (AppBitmapImage *)malloc( sizeof(AppBitmapImage) );
    if  ( ! abi )
	{ XDEB(abi); return;	}
    appInitBitmapImage( abi );

    sis= sioInXpropOpen( display, win, selEvent->property );
    if  ( ! sis )
	{ XDEB(sis); return;	}

    if  ( bmPngReadPng( &abi->abiBitmap, &abi->abiBuffer, sis ) )
	{ LDEB(1); return;	}

    tedAppReplaceSelection( ed, (const unsigned char *)0, 0 );

    if  ( tedObjectInsertBitmap( ed, abi ) )
	{ LDEB(1); sioInXpropEraseAndClose( sis ); return; }

    sioInXpropEraseAndClose( sis );

    return;
    }

void tedPastePrimaryPixmap(		Widget			w,
					EditDocument *		ed,
					XSelectionEvent *	selEvent )
    {
    EditApplication *	ea= ed->edApplication;
    TedDocument *	td= (TedDocument *)ed->edPrivateData;

    Display *		display= XtDisplay( w );
    Window		win= XtWindow( w );

    AppBitmapImage *	abi;

    if  ( ! td->tdCanReplaceSelection )
	{ LDEB(td->tdCanReplaceSelection); return;	}

    abi= (AppBitmapImage *)malloc( sizeof(AppBitmapImage) );
    if  ( ! abi )
	{ XDEB(abi); return;	}
    appInitBitmapImage( abi );

    if  ( appImgPastePixmap( abi, ea->eaMagnifiedPixelsPerTwip,
						display, win, selEvent ) )
	{ LDEB(1); return;	}

    tedAppReplaceSelection( ed, (const unsigned char *)0, 0 );

    if  ( tedObjectInsertBitmap( ed, abi ) )
	{ appCleanBitmapImage( abi ); free( abi ); return; }

    return;
    }

void tedPasteFontTed(		Widget			w,
				EditDocument *		ed,
				XSelectionEvent *	selEvent )
    {
#   define		FONTSIZ	200

    Display *			display= XtDisplay( w );
    Window			win= XtWindow( w );

    SimpleInputStream *		sis;

    char			attrString[FONTSIZ+1];
    int				l;

    sis= sioInXpropOpen( display, win, selEvent->property );
    if  ( ! sis )
	{ XDEB(sis); return;	}

    if  ( ! sioInGetString( attrString, FONTSIZ, sis ) )
	{ LDEB(1); sioInXpropEraseAndClose( sis ); return; }

    l= strlen( attrString );
    if  ( l > 0 && attrString[l-1] == '\n' )
	{ attrString[l-1]= '\0';	}

    if  ( tedAppChangeSelectionAttributeString( ed, attrString ) )
	{
	SDEB(attrString);
	sioInXpropEraseAndClose( sis );
	return;
	}

    sioInXpropEraseAndClose( sis );

    appDocumentChanged( ed->edApplication, ed, 1 );

    return;
    }

void tedPasteRulerTed(		Widget			w,
				EditDocument *		ed,
				XSelectionEvent *	selEvent )
    {
    Display *			display= XtDisplay( w );
    Window			win= XtWindow( w );

    SimpleInputStream *		sis;

    ParagraphProperties		pp;
    TextAttribute		ta;

    unsigned int		ppUpdMask;
    unsigned int		taUpdMask;

    docInitParagraphProperties( &pp );
    docInitTextAttribute( &ta );

    sis= sioInXpropOpen( display, win, selEvent->property );
    if  ( ! sis )
	{ XDEB(sis); return;	}

    if  ( docRtfReadRuler( sis, &pp ) )
	{ LDEB(1); sioInXpropEraseAndClose( sis ); return; }

    sioInXpropEraseAndClose( sis );

    taUpdMask= 0;
    ppUpdMask=	PPupdLEFT_INDENT	|
		PPupdFIRST_INDENT	|
		PPupdRIGHT_INDENT	|
		PPupdTAB_STOPS		|
		PPupdALIGNMENT		;

    if  ( tedChangeSelectionProperties( ed, taUpdMask, ta, ppUpdMask, &pp ) )
	{ LDEB(1); docCleanParagraphProperties( &pp ); return; }

    docCleanParagraphProperties( &pp );

    return;
    }
