#   include	"config.h"

#   include	"docBuf.h"
#   include	<stdio.h>
#   include	<debugon.h>

static void docListChildren(	int			indent,
				const BufferItem *	bi )
    {
    int		i;

    for ( i= 0; i < bi->biGroupChildCount; i++ )
	{
	BufferItem *	child= bi->biGroupChildren[i];

	if  ( child->biParent != bi )
	    {
	    DEBFUN( "############## %d in %d:\n",
					child->biLevel, bi->biLevel );
	    XXDEB(child->biParent,bi);
	    }

	if  ( child->biNumberInParent != i )
	    {
	    DEBFUN( "############## %d in %d:\n",
					child->biLevel, bi->biLevel );
	    LLDEB(child->biNumberInParent,i);
	    }

	if  ( child->biLevel != bi->biLevel+ 1 )
	    {
	    DEBFUN( "############## %d in %d:\n",
					child->biLevel, bi->biLevel );
	    LLDEB(child->biLevel,bi->biLevel);
	    }

	docListItem( indent+ 4, child );
	}
    }

void docListItem(	int			indent,
			const BufferItem *	bi )
    {
    int			i;
    TextParticule *	tp;

    DEBFUN( "%*sITEM %4d 0x%08lx: %s [%4d..%4d]\n",
				    indent, "", bi->biNumberInParent,
				    (unsigned long)bi,
				    docLevelStr( bi->biLevel ),
				    bi->biY0, bi->biY1 );
    fflush( stdout );
    
    switch( bi->biLevel )
	{
	case DOClevDOC:
	case DOClevSECT:
	case DOClevCELL:
	    DEBFUN( "%*s{ %4d children\n", indent+ 4, "",
						bi->biGroupChildCount );

	    docListChildren( indent, bi );

	    DEBFUN( "%*s}\n", indent+ 4, "" );
	    break;

	case DOClevROW:
	    DEBFUN( "%*s{ %4d children %d cells\n", indent+ 4, "",
						bi->biGroupChildCount,
						bi->biRowCellCount );

	    docListChildren( indent, bi );

	    DEBFUN( "%*s}\n", indent+ 4, "" );
	    break;

	case DOClevPARA:
	    DEBFUN( "%*s{ %4d particules, %4d lines\n", indent+ 4, "",
						bi->biParaParticuleCount,
						bi->biParaLineCount );

	    /*
	    DEBFUN( "%*s\"%.25s\"\n", indent+ 4, "", bi->biParaString );
	    */
	    tp= bi->biParaParticules;
	    for ( i= 0; i < bi->biParaParticuleCount; tp++, i++ )
		{
		/*
		if  ( i > 5 )
		    { DEBFUN( "%*sEtc...\n", indent+ 4, "" ); break; }
		*/

		docListParticule( indent+ 4, "PART", i, bi, tp );
		}
	    break;
	case DOClevOUT:
	default:
	    break;
	}
    
    fflush( stdout );

    return;
    }

char *	docKindStr( int kind )
    {
    static char	scratch[12];

    switch( kind )
	{
	case DOCkindTEXT:	return "txt";
	case DOCkindTAB:	return "TAB";
	case DOCkindOBJECT:	return "OBJ";
	case DOCkindFIELDSTART:	return "FLS";
	case DOCkindFIELDEND:	return "FLE";
	case DOCkindBKMKSTART:	return "BKS";
	case DOCkindBKMKEND:	return "BKE";
	case DOCkindXE:		return "XE ";
	case DOCkindTC:		return "TC ";
	default:
	    sprintf( scratch, "%03d", kind );
	    return scratch;
	}
    }

char *	docLevelStr( int level )
    {
    static char	scratch[12];

    switch( level )
	{
	case DOClevANY:		return "ANY ";
	case DOClevOUT:		return "OUT ";
	case DOClevDOC:		return "DOC ";
	case DOClevSECT:	return "SECT";
	case DOClevROW:		return "ROW ";
	case DOClevCELL:	return "CELL";
	case DOClevPARA:	return "PARA";
	case DOClevTEXT:	return "TEXT";
	default:
	    sprintf( scratch, "%03d", level );
	    return scratch;
	}
    }

char * docAttributeStr(	TextAttribute		ta )
    {
    static char	scratch[5];
    char *	to= scratch;

    if  ( ta.taFontIsBold )
	{ *(to++)= 'B';	}
    else{ *(to++)= 'b';	}
    if  ( ta.taFontIsSlanted )
	{ *(to++)= 'I';	}
    else{ *(to++)= 'i';	}
    if  ( ta.taIsUnderlined )
	{ *(to++)= 'U';	}
    else{ *(to++)= 'u';	}
    if  ( ta.taInField )
	{ *(to++)= 'F';	}
    else{ *(to++)= 'f';	}

    *(to)= '\0';

    return scratch;
    }

void docListParticule(	int			indent,
			const char *		label,
			int			n,
			const BufferItem *	bi,
			const TextParticule *	tp )
    {
    DEBFUN( "%*s%s %3d: [%4d..%4d] [%3d..%3d] %s <%s> ", indent, "", label, n,
		    tp->tpStroff, tp->tpStroff+ tp->tpStrlen,
		    tp->tpX0, tp->tpX0+ tp->tpPixelsWide,
		    docKindStr( tp->tpKind ),
		    docAttributeStr( tp->tpTextAttribute ) );

    DEBFUN( "\"%.*s\"\n",
		    (int)tp->tpStrlen,
		    bi->biParaString+ tp->tpStroff );

    fflush( stdout );

    return;
    }

void docLogRectangle(	const char *			label,
			const DocumentRectangle *	dr )
    {
    printf( "%s: [%4d+%4d]x[%4d+%4d]\n", label,
		dr->drX0, dr->drX1- dr->drX0+ 1,
		dr->drY0, dr->drY1- dr->drY0+ 1 );

    return;
    }
