;;; slovak.el -- additional Slovak keyboards

;; Copyright (C) 1997 Milan Zamazal

;; Authors:    Tibor imko <tibor.simko@fmph.uniba.sk>
;;             Milan Zamazal <pdm@fi.muni.cz>
;; Maintainer: Milan Zamazal <pdm@fi.muni.cz>
;; Version:    $Id: czech-slovak.el,v 3.8 1997/11/08 01:13:58 pdm Exp $
;; Keywords:   i18n, Slovak, keyboard
;; KnownCompatibility: 19.34

;; This file is *NOT* part of GNU Emacs.

;; COPYRIGHT NOTICE
;;
;; This program is free software; you can redistribute it and/or modify it
;; under the terms of the GNU General Public License as published by the Free
;; Software Foundation, version 2 of the License.
;;
;; This program is distributed in the hope that it will be useful, but
;; WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
;; or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
;; for more details.
;;
;; You should have received a copy of the GNU General Public License along
;; with GNU Emacs and/or this package.  If you did not, write to the
;; Free Software Foundation, Inc., 675 Mass Ave., Cambridge, MA 02139, USA.

;;; Commentary:

;; Emacs-czech does not support more than one predefined programmers keyboard.
;; However you can set additional keyboards through the function
;; `cz-set-keyboard' easily.  See `README.slovak' for ASCII graphics
;; description of the provided Slovak keyboards.

;;; Code:

(require 'czech)


(defvar cz-slovak-programmers-keyboard-1
   `(((?1 . "+") (?! . "1") (?2 . [181]) (?@ . "2") (?3 . [185]) (?# . "3")
      (?4 . [232]) (?$ . "4") (?5 . [187]) (?% . "5") (?6 . [190]) (?^ . "6")
      (?7 . [253]) (?& . "7") (?8 . [225]) (?* . "8") (?9 . [237]) (?\( . "9")
      (?0 . [233]) (?\) . "0"))
     (?+ (?a . [228]) (?A . [196]) (?c . [232]) (?C . [200]) (?d . [239])
         (?D . [207]) (?e . [236]) (?E . [204]) (?l . [181]) (?L . [165])
         (?n . [242]) (?N . [210]) (?o . [244]) (?O . [212]) (?r . [248]) 
         (?R . [216]) (?s . [185]) (?S . [169]) (?t . [187]) (?T . [171])
         (?u . [249]) (?U . [217]) (?z . [190]) (?Z . [174]))
     (?= (?a . [225]) (?A . [193]) (?e . [233]) (?E . [201]) (?i . [237]) 
         (?I . [205]) (?l . [229]) (?L . [197]) (?o . [243]) (?O . [211]) 
         (?r . [224]) (?R . [192]) (?u . [250]) (?U . [218]) 
         (?y . [253]) (?Y . [221])))
    "Definition of the Slovak programmer's keyboard no 1.")

(defvar cz-slovak-programmers-keyboard-2
   `(((?1 . "+") (?2 . [181]) (?3 . [185]) (?4 . [232]) (?5 . [187]) 
      (?6 . [190]) (?7 . [253]) (?8 . [225]) (?9 . [237]) (?0 . [233]))
     (?+ (?a . [228]) (?A . [196]) (?c . [232]) (?C . [200]) (?d . [239])
         (?D . [207]) (?e . [236]) (?E . [204]) (?l . [181]) (?L . [165])
         (?n . [242]) (?N . [210]) (?o . [244]) (?O . [212]) (?r . [248]) 
         (?R . [216]) (?s . [185]) (?S . [169]) (?t . [187]) (?T . [171])
         (?u . [249]) (?U . [217]) (?z . [190]) (?Z . [174]))
     (?= (?a . [225]) (?A . [193]) (?e . [233]) (?E . [201]) (?i . [237]) 
         (?I . [205]) (?l . [229]) (?L . [197]) (?o . [243]) (?O . [211]) 
         (?r . [224]) (?R . [192]) (?u . [250]) (?U . [218]) 
         (?y . [253]) (?Y . [221])))
    "Definition of the Slovak programmer's keyboard no 2.
This definition is the default one used in `czech-keyboard.el'.")

(defvar cz-slovak-programmers-keyboard-3
   `(()
     (?\] (?a . [228]) (?A . [196]) (?c . [232]) (?C . [200]) (?d . [239])
          (?D . [207]) (?e . [236]) (?E . [204]) (?l . [181]) (?L . [165])
          (?n . [242]) (?N . [210]) (?o . [244]) (?O . [212]) (?r . [248])
          (?R . [216]) (?s . [185]) (?S . [169]) (?t . [187]) (?T . [171])
          (?u . [249]) (?U . [217]) (?z . [190]) (?Z . [174]))
     (?\[ (?a . [225]) (?A . [193]) (?e . [233]) (?E . [201]) (?i . [237])
          (?I . [205]) (?l . [229]) (?L . [197]) (?o . [243]) (?O . [211])
          (?r . [224]) (?R . [192]) (?u . [250]) (?U . [218])
          (?y . [253]) (?Y . [221])))
    "Definition of the Slovak programmer's keyboard no 3.")


(provide 'czech-slovak)

;;; slovak.el ends here

