/****************************************************************************
|                         Digital Audio Processor
|                         =======================
|
| Filename    : lfo.h
|
| Revision    : 1.1
| Date        : 25/01/96
|
| Object      : DSPKitLFO
|
| Description : DSPKitLFO
|
| (c) Richard Kent 1996
|
| $Id$
|
****************************************************************************/

#ifndef _DSPKIT_LFO_H_
#define _DSPKIT_LFO_H_

#include "processo.h"
#include <math.h>

class DSPKitLFO : public DSPKitProcessor
{
  public:

    long setInput ();
    long setTypeAndFreq (
      long newType,
      double newInputFreq,
      double newOutputFreq, 
      double newDepth, double newPhase);
    long setExponential (double newExpPower);
    long getSample (double &outputSample);
    DSPKitProcessor *getInput ();
    
  protected:

    double depth;
    double phase;
    double inputFreq;
    double outputFreq;
    long   type;
    long   samplesPerCycle;
    double cyclesPerSample;
    double twoPiCyclesPerSample;
    long   i;
    double expPower;
};

inline long DSPKitLFO::setInput ()
{
  return 1;
}

inline DSPKitProcessor *DSPKitLFO::getInput ()
{
  return 0;
}

inline long DSPKitLFO::setExponential (double newExpPower)
{
  expPower = newExpPower;
  return 1;
}

#endif

/***************************************************************************/
