#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>
#include <sys/sysctl.h>
#include <linux/sysctl.h>
#include <linux/version.h>

#if LINUX_VERSION_CODE < 0x020120
#error "This program needs linux-2.1.32 or newer to compile"
#endif

int main(int argc, char **argv)
{
	int name[] = {CTL_KERN, KERN_PRINTK};
        int namelen = 2;
	int newval[1];
	int newlen = sizeof(newval);
	int i, error;

	if (argc != 2 || !isdigit(argv[1][0])) {
		fprintf(stderr,"%s: specify new level as aegument\n",
			argv[0]);
		exit(1);
	}
	newval[0]=atoi(argv[1]);

	error = sysctl (name, namelen, NULL /* oldval */, 0 /* len */,
		newval, newlen);
	if (error) {
		fprintf(stderr,"%s: sysctl(): %s\n",
			argv[0],strerror(errno));
		exit(1);
	}
	exit(0);
}
