#!/usr/bin/perl
print('.\\" Copyright (c) 1998 Warren D. MacEvoy jr
');
print('.\\" See Copying for conditions for redistribution
');
print('.TH PERLPP 1 "12-Oct-1998" "perlpp" "perlpp"
');
print('.SH NAME
');
print('perlpp \\- the perl pre-processor
');
print('.SH SYNOPSIS
');
print('.hy 0
');
print('.na
');
print('.TP
');
print('.B perlpp 
');
print('.RB "[\\|" \\-qq "\\|]" 
');
print('.RB "[\\|" "\\-perl\\ "\\c
');
print('.I path\\c
');
print('\\&\\|]
');
print('.RB "[\\|" "\\-o\\ "\\c
');
print('.I outfile\\c
');
print('\\&\\|]
');
print('.RB "[\\|" \\-pl "\\|]" 
');
print('.RB "[\\|" \\c
');
print('.I infile\\c
');
print('.RB | \\- "\\|]" 
');
print('.ad b
');
print('.hy 1
');
print('.SH DESCRIPTION
');
print('
');
print('.BR Perlpp
');
print('translates the input file into a perl script according to some
');
print('simple rules (see
');
print('.B TRANSLATION
');
print('below).  And either saves the generated perl script, or the output
');
print('from running that script.
');
print('
');
print('.SH OPTIONS
');
print('Perlpp has a few options
');
print('
');
print('.TP
');
print('.B \\-qq
');
print('Change the default translation rule to 
');
print('.B DOUBLE-QUOTE.
');
print('Without this option, the default translation rule is 
');
print('.B SINGLE-QUOTE.
');
print('
');
print('.TP
');
print('.BI "\\-perl " path
');
print('Use the specified absolute path in the
');
print('.B #!
');
print('notation for the first line of the perl script.
');
print('.TP
');
print('.B \\-pl
');
print('Save the generated perl script as the output file.  The default action is
');
print('to save the output (STDOUT) of executing the perl script.
');
print('.TP
');
print('.BI "\\-o " outfile
');
print('Specify the name of the output file.  The default name
');
print('of the output file is the name of the input file, with
');
print('the
');
print('.B .ppp
');
print('extension removed.
');
print('
');
print('If the
');
print('.B \\-pl
');
print('option is given, then the output file will have execute permissions set.
');
print('The default file name in this case is the input file with the 
');
print('.B .ppp
');
print('extension removed and a
');
print('.B .pl
');
print('extension added.
');
print('
');
print('.SH TRANSLATION
');
print('
');
print('The first line of the generated perl script is, 
');
print('
');
print('#!\\c
');
print('.I path
');
print('
');
print('Here, 
');
print('.I path
');
print('is either 
');
print('.B
');
print("$perlloc\\c
");
print(', or the path specified with the 
');
print('.B \\-perl
');
print('option.
');
print('
');
print('The remaining lines of the perl script are generated by translating
');
print('successive lines of the input file according to the following rules:
');
print('
');
print('.TP
');
print('.B BANG(!)
');
print('The perl source rule.  If the first character of a line 
');
print('is a 
');
print('.B !
');
print('(bang), then copy the remainding part of the line to 
');
print('the generated perl script.
');
print('
');
print('.TP
');
print('.B SINGLE-QUOTE(\')
');
print('If the first character of a line is a
');
print('.B \'
');
print('(single quote), or if none of the
');
print('above rules apply, then generate a single-quoted (uninterpolated)
');
print('print statment.  Excuting this print statement will produce
');
print('the remaining part of the input line exactly---including the
');
print('terminating new line.
');
print('
');
print('.TP
');
print('.B DOUBLE-QUOTE(")
');
print('The print interpolated rule.   If the first character of a line is a 
');
print('.B """"
');
print('(double quote), then generate a double-quoted (interpolating) print
');
print('statement.  Executing this print statement will produce the
');
print('interpolated version of the rest of the input line---including the
');
print('terminating new line.  See the 
');
print('.B perlop\\c
');
print('(1) man page for details about interpolating strings.
');
print('
');
print('.TP
');
print('.B BACK-QUOTE(`)
');
print('The print system rule.  If the first character
');
print('of a line is a 
');
print('.B `
');
print('(back quote), then generate a back-quoted
');
print('(system) print statment.  Executing this print statement will
');
print('produce the output of, first, interpolating the remaining part
');
print('of the input line like the 
');
print('.B """"\\c
');
print('-rule above, then running that result as a shell command.
');
print('
');
print('.TP
');
print('.B DEFAULT
');
print('The default rule is to treat the line as if it were preceeded by
');
print('either a single quote (without the 
');
print('.B \\-qq
');
print('option) or a double quote (print with the
');
print('.B \\-qq
');
print('option).
');
print('
');
print('.SH EXAMPLE
');
print('
');
print('If the file 
');
print('.B example.ppp
');
print('containes the text
');
print('
');
print('  `uname -n
');
print('  ! foreach $i (\'a\'..\'c\') {
');
print('  "The value of \\\\$i is "$i".
');
print('  ! }
');
print('  The previous three lines of output was generated by
');
print('    
');
print('  \'! foreach $i (\'a\'..\'c\') {
');
print('  \'"The value of \\\\$i is "$i".
');
print('  \'! }
');
print('    
');
print('  Isn\'t that clever?
');
print('
');
print('Then running
');
print('
');
print('.B "  perlpp -pl example.ppp"
');
print('
');
print('will create the perl script 
');
print('.B example.pl\\c
');
print(',
');
print('
');
print("    #!$perlloc
");
print('    print(`uname -n`);
');
print('     foreach $i (\'a\'..\'c\') {
');
print('    print("The value of \\\\$i is \\\\"$i\\\\".
');
print('    ");
');
print('     }
');
print('    print(\'The previous three lines of output was generated by
');
print('    \');
');
print('    print(\'
');
print('    \');
');
print('    print(\'! foreach $i (\\\\\'a\\\\\'..\\\\\'c\\\\\') {
');
print('    \');
');
print('    print(\'"The value of \\\\\\\\$i is "$i".
');
print('    \');
');
print('    print(\'! }
');
print('    \');
');
print('    print(\'
');
print('    \');
');
print('    print(\'Isn\\\\\'t that clever?
');
print('    \');
');
print('
');
print('This script can be run directly,
');
print('
');
print('.B "  ./example.pl > example"
');
print('
');
print('Or perlpp can recreate it and run it for you,
');
print('
');
print('.B "  perlpp example.ppp"
');
print('
');
print('In either case, 
');
print('.B example
');
print('will contain the output
');
print('
');
print('    your.machine.name
');
print('    The value of $i is "a".
');
print('    The value of $i is "b".
');
print('    The value of $i is "c".
');
print('    The previous three lines of output was generated by
');
print('    
');
print('    ! foreach $i (\'a\'..\'c\') {
');
print('    "The value of \\\\$i is "$i".
');
print('    ! }
');
print('    
');
print('    Isn\'t that clever?
');
print('  
');
print('When the intermediate perl script, 
');
print('.B example.pl\\c
');
print(', is not required, it
');
print('does not have to be explicitly generated.
');
print('
');
print('.SH SEE ALSO
');
print('
');
print('.B perl\\c
');
print('(1)
');
print('
');
print('.SH AUTHOR
');
print('
');
print('Warren D. MacEvoy, copyright (c) 1998 under the Gnu Public License,
');
print('version 1 or later.
');
print('
');
print('
');
print('
');
