/*
 * ===========================
 * VDK Builder
 * Version 0.1
 * Revision 0.0
 * November 1998
 * ===========================
 *
 * Copyright (C) 1998,1999 Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 *
 * Based on VDK Library
 * Copyright (C) 1998, Mario Motta
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 *
 */
#include <vdkb/vdkb_prj.h>
#include <vdkb/vdkb.h>
#include <vdkb/vdkb_utils.h>
#include <vdkb/vdkb_types.h>
#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>
#include <vdkb/vdkb_editor.h>
#include <sys/param.h>

static char buff[1024];
extern char *ext_types[];
static void WriteDependencies(FILE* fp, char* complete_name,
			      char* avoid = NULL);

/////////////////////////
bool
VDKBProject::WriteMainHForConsole(FILE* fp)
{
  char* h_ext  = (char*) VDKBuilder::ideDefaults.unit.h_ext;
  int len = strlen(Name);
  char* name = new char[len+1];
  strcpy(name, Name);
  char* p = get_extension(name);
  if(p)
    *p = '\0';
  fprintf(fp,"/*\n%s Console Application",name);
  fprintf(fp,"\nMain unit header file: %s.%s",name,h_ext);
  fprintf(fp,"\n*/");
  fprintf(fp,"\n#ifndef _%s_main_h_",name);
  fprintf(fp,"\n#define _%s_main_h_",name);
  fprintf(fp,"\n#include <stdlib.h>");
  fprintf(fp,"\n");
  fprintf(fp,"\n");
  fprintf(fp,"\n#endif");
  fclose(fp);
  delete[] name;
  return true;
}
/*
 */
bool
VDKBProject::WriteMainH(FILE* fp, int type)
{
  char* h_ext  = (char*) VDKBuilder::ideDefaults.unit.h_ext;
  int len = strlen(Name);
  char* name = new char[len+1];
  strcpy(name, Name);
  char* p = get_extension(name);
  if(p)
    *p = '\0';
  fprintf(fp,"/*\n%s %s Application",
	  name,
	  type == vdk_project ? "Plain VDK" : "VDK Gnome compliant");
  fprintf(fp,"\nMain unit header file: %s.%s",name,h_ext);
  fprintf(fp,"\n*/");
  fprintf(fp,"\n#ifndef _%s_main_form_h_",name);
  fprintf(fp,"\n#define _%s_main_form_h_",name);
  fprintf(fp,"\n#include <vdk/vdk.h>");
  name[0] = toupper(name[0]);
  fprintf(fp,"\n// %s FORM  CLASS",name);
  fprintf(fp,"\nclass %sForm: public %s", name,
	  type == vdk_project ? "VDKForm" : "VDKGnomeForm");
  fprintf(fp,"\n{");
  fprintf(fp,"\n// gui object declarations");
  fprintf(fp,"\nprivate:");
  fprintf(fp,"\n// vdkbuilder reserved gui construction");
  fprintf(fp,"\n\tvoid GUISetup(void);");
  fprintf(fp,"\n");
  fprintf(fp,"\npublic:");
  fprintf(fp,"\n\t%sForm(%s* app, char* title);",
	  name,
	  type == vdk_project ? "VDKApplication" : "VDKGnomeApplication"
	  );
  fprintf(fp,"\n\t~%sForm();", name);
  fprintf(fp,"\n\tvoid Setup(void);");
  fprintf(fp,"\n/*\n gui setup include ");
  fprintf(fp,"\n do not patch below here\n*/");
  name[0] = tolower(name[0]);
  fprintf(fp,"\n#include <%s_gui.%s>",name,h_ext);
  fprintf(fp,"\n};");
  name[0] = toupper(name[0]);
  fprintf(fp,"\n\n\n// %s APPLICATION  CLASS",name);
  fprintf(fp,"\nclass %sApp: public %s", name,
	  type == vdk_project ? "VDKApplication" : "VDKGnomeApplication");
  fprintf(fp,"\n{");
  fprintf(fp,"\n");
  fprintf(fp,"\npublic:");
  fprintf(fp,"\n\t%sApp(int* argc, char** argv);", name);
  fprintf(fp,"\n\t~%sApp();", name);
  fprintf(fp,"\n\tvoid Setup(void);");
  fprintf(fp,"\n};\n");
  fprintf(fp,"\n#endif");
  fclose(fp);
  delete[] name;
  return true;
}
/*
 */
bool
VDKBProject::WriteGUISetup(FILE* fp, int type)
{
  char* h_ext  = (char*) VDKBuilder::ideDefaults.unit.h_ext;
  int len = strlen(Name);
  char* name = new char[len+1];
  strcpy(name, Name);
  char* p = get_extension(name);
  if(p)
    *p = '\0';
  fprintf(fp,"\n#include <%s.%s>",name,h_ext);
  name[0] = toupper(name[0]);
  fprintf(fp,"\n/*\nform GUI setup\n*/");
  fprintf(fp,"\nvoid\n%sForm::GUISetup(void)\n{",
	  name);
  fprintf(fp,"\n\tTitle = \"%s\";",name);
  fprintf(fp,"\n\tthis->SetSize(400,300);");
  fprintf(fp,"\n}\n");
  fclose(fp);
  delete[] name;
  return true;
}

/*
 */
bool
VDKBEditor::WriteFormCC(char* fname, FILE* fp)
{
  char* h_ext  = (char*) VDKBuilder::ideDefaults.unit.h_ext;
  char* cc_ext  = (char*) VDKBuilder::ideDefaults.unit.cc_ext;
  char* name;
  char* memname = new char[strlen(fname)+1];
  strcpy(memname,fname);
  char* p = get_shortfilename(memname);
  if(p)
    name = p;
  else
    {
      delete[] memname;
      return false;
    }
  fprintf(fp,"/*\n%s Form",name);
  fprintf(fp,"\nimplementation file:%s.%s",name,cc_ext);
  fprintf(fp,"\n*/");
  fprintf(fp,"\n#include <%s.%s>",name,h_ext);
  name[0] = toupper(name[0]);
  fprintf(fp,"\n// %s FORM  CLASS",name);
  fprintf(fp,"\n/*\nform constructor\n*/");
  fprintf(fp,"\n%sForm::%sForm(VDKForm* owner, char* title):",
	  name,name);
  fprintf(fp,"\n\tVDKForm(owner,title)\n{\n}\n");
  fprintf(fp,"\n/*\nform destructor\n*/");
  fprintf(fp,"\n%sForm::~%sForm()\n{\n}\n",
	  name,name);
  fprintf(fp,"\n/*\nform setup\n*/");
  fprintf(fp,"\nvoid\n%sForm::Setup(void)\n{",
	  name);
  fprintf(fp,"\n\tGUISetup(); // vdkb gui setup");
  fprintf(fp,"\n// put your code below here");
  fprintf(fp,"\n");
  fprintf(fp,"\n}\n");
  fclose(fp);
  delete memname;
  return true;
}

/*
 */
bool
VDKBEditor::WriteFormH(char* fname,FILE* fp)
{
  char* h_ext  = (char*) VDKBuilder::ideDefaults.unit.h_ext;
  char* name;
  char* memname = new char[strlen(fname)+1];
  strcpy(memname,fname);
  char* p = get_shortfilename(memname);
  if(p)
    name = p;
  else
    {
      delete[] memname;
      return false;
    }
  fprintf(fp,"/*\n%s Form",name);
  fprintf(fp,"\nheader file: %s.%s",name,h_ext);
  fprintf(fp,"\n*/");
  fprintf(fp,"\n#ifndef _%s_form_h_",name);
  fprintf(fp,"\n#define _%s_form_h_",name);
  fprintf(fp,"\n#include <vdk/vdk.h>");
  name[0] = toupper(name[0]);
  fprintf(fp,"\n// %s FORM  CLASS",name);
  fprintf(fp,"\nclass %sForm: public VDKForm", name);
  fprintf(fp,"\n{");
  fprintf(fp,"\n// gui object declarations");
  name[0] = toupper(name[0]);
  fprintf(fp,"\nprivate:");
  fprintf(fp,"\n// vdkbuilder reserved gui construction");
  fprintf(fp,"\n\tvoid GUISetup(void);");
  fprintf(fp,"\n");
  fprintf(fp,"\npublic:");
  fprintf(fp,"\n\t%sForm(VDKForm* owner, char* title);", name);
  fprintf(fp,"\n\t~%sForm();", name);
  fprintf(fp,"\n\tvoid Setup(void);");
  fprintf(fp,"\n/*\n gui setup include ");
  fprintf(fp,"\n do not patch below here\n*/");
  name[0] = tolower(name[0]);
  fprintf(fp,"\n#include <%s_gui.%s>",name,h_ext);
  fprintf(fp,"\n};");
  fprintf(fp,"\n#endif");
  fclose(fp);
  delete[] memname;
  return true;
}
/*
 */
bool
VDKBProject::WriteMainCC(FILE* fp, int type)
{
  char* h_ext  = (char*) VDKBuilder::ideDefaults.unit.h_ext;
  char* cc_ext  = (char*) VDKBuilder::ideDefaults.unit.cc_ext;
  int len = strlen(Name);
  char* name = new char[len+1];
  strcpy(name, Name);
  char* p = get_extension(name);
  if(p)
    *p = '\0';
  fprintf(fp,"/*\n%s %s Application",
	  name,
	  type == vdk_project ? "Plain VDK" : "VDK Gnome compliant");
  fprintf(fp,"\nMain unit implementation file:%s.%s",name,cc_ext);
  fprintf(fp,"\n*/");
  fprintf(fp,"\n#include <%s.%s>",name,h_ext);
  name[0] = toupper(name[0]);
  fprintf(fp,"\n/*\nmain program\n*/");
  fprintf(fp,"\nint main (int argc, char *argv[])");
  fprintf(fp,"\n{");
  fprintf(fp,"\n\t%sApp app(&argc, argv);",name);
  fprintf(fp,"\n\tapp.Run();");
  fprintf(fp,"\n\treturn 0;");
  fprintf(fp,"\n}\n");

  fprintf(fp,"\n// %s MAIN FORM  CLASS",name);
  fprintf(fp,"\n/*\nmain form constructor\n*/");
  fprintf(fp,"\n%sForm::%sForm(%s* app, char* title):",
	  name,
	  name,
	  type == vdk_project ? "VDKApplication" : "VDKGnomeApplication");
  fprintf(fp,"\n\t%s(app,title)\n{\n}\n",
	  type == vdk_project ? "VDKForm" : "VDKGnomeForm");
  fprintf(fp,"\n/*\nmain form destructor\n*/");
  fprintf(fp,"\n%sForm::~%sForm()\n{\n}\n",
	  name,name);
  fprintf(fp,"\n/*\nmain form setup\n*/");
  fprintf(fp,"\nvoid\n%sForm::Setup(void)\n{",
	  name);
  fprintf(fp,"\n\tGUISetup(); // vdkb gui setup");
  fprintf(fp,"\n// put your code below here");
  fprintf(fp,"\n");
  fprintf(fp,"\n}\n");

  fprintf(fp,"\n// %s APPLICATION  CLASS",name);
  fprintf(fp,"\n/*\napplication constructor\n*/");
  fprintf(fp,"\n%sApp::%sApp(int* argc, char** argv):",
	  name,name);
  if(type == vdk_project)
      fprintf(fp,"\n\tVDKApplication(argc,argv)\n{\n}\n");
  else
      fprintf(fp,"\n\tVDKGnomeApplication(\"%s\",\"%s\",argc,argv)\n{\n}\n",
	      name,name);
  fprintf(fp,"\n/*\napplication destructor\n*/");
  fprintf(fp,"\n%sApp::~%sApp()\n{\n}\n",
	  name,name);
  fprintf(fp,"\n/*\napplication setup\n*/\n");
  fprintf(fp,"\nvoid\n%sApp::Setup(void)\n{",
	  name);
  fprintf(fp,"\n\tMainForm = new %sForm(this,NULL);",name);
  fprintf(fp,"\n\tMainForm->Setup();");
  fprintf(fp,"\n\tMainForm->Visible = true;");
  fprintf(fp,"\n}\n");
  fclose(fp);
  delete[] name;
  return true;
}
/*
 */
bool
VDKBProject::WriteMainCCForConsole(FILE* fp)
{
  char* h_ext  = (char*) VDKBuilder::ideDefaults.unit.h_ext;
  char* cc_ext  = (char*) VDKBuilder::ideDefaults.unit.cc_ext;
  int len = strlen(Name);
  char* name = new char[len+1];
  strcpy(name, Name);
  char* p = get_extension(name);
  if(p)
    *p = '\0';
  fprintf(fp,"/*\n%s ConsoleApplication",name);
  fprintf(fp,"\nMain unit implementation file:%s.%s",name,cc_ext);
  fprintf(fp,"\n*/");
  fprintf(fp,"\n#include <%s.%s>",name,h_ext);
  fprintf(fp,"\n/*\nmain program\n*/");
  fprintf(fp,"\nint main (int argc, char *argv[])");
  fprintf(fp,"\n{");
  fprintf(fp,"\n");
  fprintf(fp,"\n\treturn 0;");
  fprintf(fp,"\n");
  fprintf(fp,"\n}\n");

  fclose(fp);
  delete name;
  return true;
}
/*
 */
#define THIS "this"
bool
VDKBEditor::WriteFrm(char* fname,FILE* fp)
{
  char* name;
  char* memname = new char[strlen(fname)+1];
  strcpy(memname,fname);
  char* p = get_shortfilename(memname);
  if(p)
    name = p;
  else
    {
      delete[] memname;
      return false;
    }
  fprintf(fp,"[%s]\
\n{\
\n\tclass:form;\
\n\t%s.this:%s;\
\n\t%s.NormalBackground:nihil;\
\n\t%s.Foreground:nihil;\
\n\t%s.Font:nihil;\
\n\t%s.Cursor:nihil;\
\n\t%s.Usize: 400, 300;\
\n\t%s.Title:\"%s Form\";\
\n}",
name,
name,name,name,name,name,name,name,name,
name);
delete[] memname;
fclose(fp);
return true;
}
/*
 */
bool
VDKBProject::WriteDfmFile(FILE* fp, int type)
{
  int len = strlen(Name);
  char* name = new char[len+1];
  strcpy(name, Name);
  char* p = get_extension(name);
  if(p)
    *p = '\0';
  fprintf(fp,"[%s]\
\n{\
\n\tclass:%s;\
\n\t%s.this:%s;\
\n\t%s.NormalBackground:nihil;\
\n\t%s.Foreground:nihil;\
\n\t%s.Font:nihil;\
\n\t%s.Cursor:nihil;\
\n\t%s.Usize: 400, 300;\
\n\t%s.Title:\"%s Main Form\";\
\n}",
	  name,
	  type == vdk_project ? "form" : "gnomeform",
	  name,name,name,name,name,name,name,name,
	  name);
fclose(fp);
delete[] name;
return true;
}
/*
 */
bool
VDKBProject::WriteMakefile(FILE* fp)
{
  VDKString pathname = PathName;
  VDKString path = Path;
  VDKString name = Name;
  char* cc_ext  = (char*) VDKBuilder::ideDefaults.unit.cc_ext;
  char* h_ext  = (char*) VDKBuilder::ideDefaults.unit.h_ext;
  char* c_ext   = "c";

  fprintf(fp,"\
# Makefile for building\n\
# %s\n
\n\
####### Compiler, tools and options\
", (char*) pathname);

  fprintf(fp,"\
\nC        =  %s\
\nCC       =  %s\
\nCFLAGS   =  %s\
",
(char*) options.c_compiler,
(char*) options.cc_compiler,
(char*) options.c_flags
);

  fprintf(fp,"\
\nINCPATH  = %s\
",
(char*) options.includes
);

  fprintf(fp,"\
\nDEFD     = %s\
",
(char*) options.defines
);

 fprintf(fp,"\
\nLINK     =  %s\
\nLIBS     =  %s\
\n\
\n####### Files\
",
(char*) options.link,
(char*) options.libs
);
  /*
    DIRS
  */
 //  char* p;
  fprintf(fp,"\nPRJ_DIR =\t%s\n", (char*) path);
  /*
    HEADERS
  */
  fprintf(fp,"\
\nHEADERS =");
  int t = 0;
  UnitListIterator li(units);
  for(;li && t < units.size();li++,t++)
    {
      VDKBUnit * unit = li.current();
      char* complete_name = new char[ strlen(unit->Header()) + 1];
      strcpy(complete_name,unit->Header());
      char* namepath = NULL;
      if(! access(complete_name,F_OK) )
	{
	namepath =  get_path(complete_name);
	if(namepath && !strcmp(namepath,(char*) path))
	   fprintf(fp,"\t$(PRJ_DIR)/%s\\\n",get_shortfilename(complete_name));
	else
	  fprintf(fp,"\t%s\\\n",complete_name);
	}
      if(namepath)
	delete[] namepath;
      delete[] complete_name;

      char* gui = unit->DfmHeader();
      complete_name = new char[ strlen(gui) + 1];
      strcpy(complete_name,gui);
      namepath = NULL;
      if(! access(gui,F_OK))
	{
	namepath =  get_path(complete_name);
	if(namepath && !strcmp(namepath,(char*) path))
	   fprintf(fp,"\t$(PRJ_DIR)/%s\\\n",get_shortfilename(complete_name));
	else
	  fprintf(fp,"\t%s\\\n",complete_name);
	}
      if(namepath)
	delete[] namepath;
      delete[] complete_name;
    }

  fprintf(fp,"\n\n");
  /*
    SOURCES
  */
  fprintf(fp,"\
\nSOURCES = ");
  t = 0;
  li.restart();
  for(;li && t < units.size();li++,t++)
    {
      if(li.current()->IsSource())
	{
	   char* complete_name = new char[ strlen(li.current()->Source()) + 1];
	   strcpy(complete_name,li.current()->Source());
	   char* namepath =  get_path(complete_name);
	   if(namepath && !strcmp(namepath,(char*) path))
	     fprintf(fp,"\t$(PRJ_DIR)/%s\\\n",
		     get_shortfilename(complete_name));
	   else
	     fprintf(fp,"\t%s\\\n",li.current()->Source());
	   if(namepath)
	     delete[] namepath;
	   delete[] complete_name;


	   char* gui = li.current()->GuiSource();
	   complete_name = new char[ strlen(gui) + 1];
	   strcpy(complete_name,gui);
	   namepath = NULL;
	   if(! access(gui,F_OK))
	     {
	       namepath =  get_path(complete_name);
	       if(namepath && !strcmp(namepath,(char*) path))
		 fprintf(fp,"\t$(PRJ_DIR)/%s\\\n",
			 get_shortfilename(complete_name));
	       else
		 fprintf(fp,"\t%s\\\n",gui);
	     }
	   if(namepath)
	     delete[] namepath;
	   delete[] complete_name;
	}
    }
  fprintf(fp,"\n\n");
/*
    OBJECTS
  */
  fprintf(fp,"\
\nOBJECTS =");
  t = 0;
  li.restart();
  for(;li && t < units.size();li++,t++)
    if(li.current()->IsSource())
      {
	char* complete_name = new char[ strlen(li.current()->Name()) + 1];
	strcpy(complete_name,li.current()->Name());
	char* namepath =  get_path(complete_name);
	if(namepath && !strcmp(namepath,(char*) path))
	  fprintf(fp,"\t$(PRJ_DIR)/%s.o\\\n",
		    get_shortfilename(complete_name));
	else
	  fprintf(fp,"\t%s.o\\\n",li.current()->Name());

	if(namepath)
	  delete[] namepath;
	delete[] complete_name;

	char* gui = li.current()->Name();
	complete_name = new char[ strlen(gui) + 1];
	strcpy(complete_name,gui);
	namepath = NULL;
	if(! access(li.current()->GuiSource(),F_OK))
	  {
	    namepath =  get_path(complete_name);
	    if(namepath && !strcmp(namepath,(char*) path))
	      fprintf(fp,"\t$(PRJ_DIR)/%s_gui.o\\\n",
		      get_shortfilename(complete_name));
	    else
	      fprintf(fp,"\t%s_gui.o\\\n",li.current()->Name());
	  }
	if(namepath)
	  delete[] namepath;
	delete[] complete_name;
      }
  fprintf(fp,"\n\n");
  /*
    OTHERS OBJECTS
  */
  fprintf(fp,"\nOTHERS_OBJECTS =");
  t = 0;
  li.restart();
  for(;li && t < units.size();li++,t++)
    {
      if(li.current()->Type() == object_unit ||
	 li.current()->Type() == staticlib_unit )
	{
	  char* complete_name = new char[ strlen(li.current()->Name()) + 1];
	  strcpy(complete_name,li.current()->Name());
	  char* namepath =  get_path(complete_name);
	  if(namepath && !strcmp(namepath,(char*) path))
	    fprintf(fp,"\t$(PRJ_DIR)/%s.%s\\\n",
		    get_shortfilename(complete_name),
		    ext_types[li.current()->Type()]);
	  else
	    fprintf(fp,"\t%s.%s\\\n",
		    li.current()->Name(),
		    ext_types[li.current()->Type()]);
	  if(namepath)
	    delete[] namepath;
	  delete[] complete_name;
	}
    }
  fprintf(fp,"\n\n");
  /*
    TARGET
  */
  VDKString executable = /* path + "/" + */  name;
  VDKString builder_exe = "./";
  builder_exe+=name;
  char* p = get_extension ( (char*) executable);
  if(p) *p = '\0';
  fprintf(fp,"\nTARGET =\t%s", (char*) executable);
  p = get_extension ( (char*) builder_exe);
  if(p)  *p = '\0';
  /*
    program args
   */
  fprintf(fp,"\n\nPRG_ARGS =\t%s\n", (char*) options.runargs);
  /*
    RULES
  */
 VDKString cwd;
 char* pw = getcwd(NULL,MAXPATHLEN);
 if(pw)
   {  cwd = pw; free(pw);  }
 fprintf(fp,"\
\n####### Implicit rules\
\n.SUFFIXES: .%s .%s\
\n\
\n.%s.o:\
\n\t$(CC) -c   $(CFLAGS) $(INCPATH) $(DEFD) -o $@ $<\
\n\
\n.%s.o:\
\n\t$(C)  -c   $(CFLAGS) $(INCPATH) $(DEFD) -o $@ $<\
\n\
\n####### Build rules\
\n\
\nall: $(TARGET)\
\n\
\n$(TARGET): $(OBJECTS)\
\n\t$(LINK)  -o $(TARGET) $(OBJECTS) $(OTHERS_OBJECTS) $(LIBS)\
\n\
\n####### Running (used by builder)
\nrun: $(TARGET)
\n\tcd %s
\n\t%s $(PRG_ARGS)
\n\tcd %s
\n\
\nclean:\
\n\t-rm -f $(OBJECTS) $(TARGET)\
\n\t-rm -f *~ core\
\n\
\n####### Compile\
",
cc_ext,c_ext,cc_ext,c_ext,(char*) path, (char*) builder_exe,(char*) cwd);

char* dependFile;

fprintf(fp,"\n");
  li.restart();
  for(;li ;li++)
    {
      char* complete_name;
      char* namepath;
      fprintf(fp,"\n\n");
      if(li.current()->IsSource())
	{
	  complete_name = new char[ strlen(li.current()->Name()) + 1];

	  strcpy(complete_name,li.current()->Name());
	  namepath =  get_path(complete_name);
	  if(namepath && !strcmp(namepath,(char*) path))
	    sprintf(buff,"$(PRJ_DIR)/%s.o : ",
		    get_shortfilename(complete_name));
	  else
	    sprintf(buff,"%s.o : ",li.current()->Name());
	  fprintf(fp,buff);
	  if(namepath)
	    delete[] namepath;
	  delete[] complete_name;

	  complete_name = new char[ strlen(li.current()->Source()) + 1];
	  strcpy(complete_name,li.current()->Source());
	  // for WriteDependencies()
	  dependFile = new char[ strlen(li.current()->Source()) + 1];
	  strcpy(dependFile,li.current()->Source());
	  namepath =  get_path(complete_name);
	  if(namepath && !strcmp(namepath,(char*) path))
	    sprintf(buff,"$(PRJ_DIR)/%s",get_shortfilename(complete_name));
	  else
	    sprintf(buff,"%s",li.current()->Source());
	  fprintf(fp,buff);
	  if(namepath)
	    delete[] namepath;
	  delete[] complete_name;

	  if(! access(li.current()->Header(),F_OK))
	    {
	      complete_name = new char[ strlen(li.current()->Header()) + 1];
	      strcpy(complete_name,li.current()->Header());
	      namepath =  get_path(complete_name);
	      if(namepath && !strcmp(namepath,(char*) path))
		;
	      else
		{
		  sprintf(buff,"\\\n\t%s", li.current()->Header());
		  fprintf(fp,buff);
		}
	      // dependencies
	      WriteDependencies(fp,dependFile);
	      WriteDependencies(fp,complete_name);
	      delete[] dependFile;
	      if(namepath)
		delete[] namepath;
	      delete[] complete_name;
	    }

	  if(! access(li.current()->Dfm(),F_OK))
	    {
	      complete_name = new char[ strlen(li.current()->Name()) + 1];
	      strcpy(complete_name,li.current()->Name());
	      namepath =  get_path(complete_name);
	      if(namepath && !strcmp(namepath,(char*) path))
		{
		sprintf(buff,"\n\n$(PRJ_DIR)/%s_gui.o : ",
			get_shortfilename(complete_name));
		fprintf(fp,buff);
		sprintf(buff,"$(PRJ_DIR)/%s_gui.%s",
			get_shortfilename(complete_name),cc_ext);
		fprintf(fp,buff);
		sprintf(buff,"\\\n\t$(PRJ_DIR)/%s_gui.%s\n",
			get_shortfilename(complete_name),h_ext);
		fprintf(fp,buff);
		}
	      else
		{
		  sprintf(buff,"\n%s_gui.o : ", li.current()->Name());
		  fprintf(fp,buff);
		  sprintf(buff,"%s_gui.%s",li.current()->Name(),cc_ext);
		  fprintf(fp,buff);
		  sprintf(buff,"\\\n\t%s_gui.%s\n",
			  li.current()->Name(),h_ext);
		  fprintf(fp,buff);
		}
	      if(namepath)
		delete[] namepath;
	      delete[] complete_name;
	    }
	}
    }
return true;
}

void
WriteDependencies(FILE* fp, char* complete_name, char* avoid)
{
FILE* sfp = fopen(complete_name,"r");
char local[512];
if(!sfp)
    return;
while(fgets(local,511,sfp))
  {
    if(strstr(local,"include"))
      {
	char tgt[256];
	if( (ExtractWord(local,tgt,"<",">") ||
	     ExtractWord(local,tgt,"\"","\""))
	    &&
	    (!access(tgt,F_OK))
	    )
	  {
	    if( (!avoid) || (avoid && strcmp(tgt,avoid)) )
	      {
		sprintf(buff,"\\\n\t$(PRJ_DIR)/%s",tgt);
		fprintf(fp,buff);
	      }
	  }
      }
  }
fclose(sfp);
}

/*
 */
bool
VDKBProject::WriteSourcesForAutomake(FILE* fp)
{
  VDKString tmp;
  UnitListIterator li(units);
  for(;li;li++)
    {
      VDKBUnit * unit = li.current();
      tmp = get_shortfilename((char*) unit->Header());
      if(! access(unit->Header(),F_OK) )
	fprintf(fp,"\\\n\t%s",(char*) tmp);
      tmp = get_shortfilename((char*) unit->DfmHeader());
      if(! access(unit->DfmHeader(),F_OK))
	fprintf(fp,"\\\n\t%s",(char*) tmp);
    }
  li.restart();
  for(;li;li++)
    {
      if(li.current()->IsSource())
	{
	  if(! access(li.current()->Source(),F_OK))
	    {
	      tmp = get_shortfilename((char*) li.current()->Source());
	      fprintf(fp,"\\\n\t%s",(char*) tmp);
	      char* gui = li.current()->GuiSource();
	      tmp = get_shortfilename(li.current()->GuiSource());
	      if(! access(gui,F_OK))
		fprintf(fp,"\\\n\t%s",(char*) tmp);
	    }
	}
    }
  fprintf(fp,"\n\n");
  return true;
}


