/*
 * ===========================
 * VDK Builder
 * Version 0.1.1
 * Revision 0.0 
 * March 1999
 * ===========================
 *
 * Copyright (C) 1998, Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-130
 */ 
#include <vdkb/vdkb_pbar.h>
#include <vdkb/vdkb_evbox.h>
#include <vdkb/vdkb_utils.h>
#include <vdkb/vdkb_form.h>
#include <vdkb/vdkb_parser.h>
#include <vdkb/vdkb_objinspect.h>
#include <vdkb/vdkb_prjman.h>
#include <stdlib.h>
#include <vdkb/vdkb_fixed.h>
/*
================================
symbolic constants to templatize
a bit 
================================
*/
// for methods and other stuff
#define CLASS VDKBProgressBar
// put here vdk class name string
#define VDK_CLASS "VDKProgressBar"
// put here vdk class name 
#define VDK_ANCESTOR  VDKProgressBar
// put here here the widget will be named
// (name+counter)
#define VDK_WIDGET "progressbar"
//=================================================================
static char buff[128];

// used to autogenerate default
// button  names and captions

int CLASS::Counter = 0;
/* 
 label button properties names
 */
char* vdkpbar_props[] =
{ 
BARBLOCKCOUNT,BARSTYLE,
BARORIENTATION,BARACTIVITYMODE,
BARMIN,BARMAX,
0
};

//////////////////////////////////////////////////
// dynamic tables
DEFINE_SIGNAL_LIST(CLASS,VDKBEvProgressBar);
DEFINE_EVENT_LIST(CLASS,VDKBEvProgressBar);
//////////////////////////////////////////////////////////////
/*
  - constructor
 */
CLASS::CLASS(char* name, 
			       VDKForm* owner,
			       float min,
			       float max):
  VDKBEvProgressBar(owner,min,max),
  VDKBObject(name)
{
  int t;
  // newly constructed widget counter is incremented
  // each time 
  Counter++;
  // assign this to VDKBObject <object> member.
  object = this;
  // add to VDKBObject properties list 
  // (Others props are prepended  by VDKBObject constructor)
  for(t=0; vdkpbar_props[t]; t++)
    proplist.add(VDKBProperty(vdkpbar_props[t]));
  sprintf(buff,"%f",min);
  SetPropValue(BARMIN,buff);
  sprintf(buff,"%f",max);
  SetPropValue(BARMAX,buff);
  // progress bar not expand
  SetPropValue(JUSTIFY_INTERNAL,"l_justify");
  SetPropValue( EXPAND_INTERNAL,CHECK_FALSE);
  SetPropValue( FILL_INTERNAL,CHECK_FALSE);
  SetPropValue(PADDING_INTERNAL,CHECK_FALSE);
  // connects events.
 CONNECT_COMMON_EVENTS;
  // makes a pop menu common to all widgets (in vdkb_widpopmenu.cc/h)
  // this pop menu will be popped at righ button press event.
  popmenu = new VDKBWidgetPopMenu(this);
  // set bar to max value
  Update(max);
}
////////////////////////////////////////////////////////////////
//
//               WRITER TO .FRM FILE
//
///////////////////////////////////////////////////////////////
/*
Writes a .frm format representation of label button widget
This virtual function is called by VDKBForm::WriteBoxesOnFrm()
a recursive algorithm that scans VDKBForm widget tree.
*/
void
CLASS::WriteOnFrm(FILE* fp, VDKBObject* parentobj)
{
  // first of all call ancestor to write common properties
  VDKBObject::WriteOnFrm(fp,parentobj);
  fprintf(fp,"\n\t%s%s;",PROP_BARMIN,(char*) GetProp(BARMIN));
  fprintf(fp,"\n\t%s%s;",PROP_BARMAX,(char*) GetProp(BARMAX));
  fprintf(fp,"\n\t%s%s;",
	  PROP_BARBLOCKCOUNT,(char*) GetProp(BARBLOCKCOUNT));
  fprintf(fp,"\n\t%s%s;",PROP_BARSTYLE,(char*) GetProp(BARSTYLE));
  fprintf(fp,"\n\t%s%s;",
	  PROP_BARORIENTATION,(char*) GetProp(BARORIENTATION));
  fprintf(fp,"\n\t%s%s;",
	  PROP_BARACTIVITYMODE,(char*) GetProp(BARACTIVITYMODE));
}
//////////////////////////////////////////////////////////////////
//
//               PREPARE GUI WIDGETS
//
//////////////////////////////////////////////////////////////////
/*
This method is called by global MakeWidget() in vdkb_design.cc
MakeWidget() scans a table that maps class id's with each
static MakeWidget() for each class. Class id's are generated
during clicks on widget palette.
On return:
0 - successfull
1 - unsupported widget
2 - target is not a container
 */
int
CLASS::MakeWidget(VDKBGuiForm* owner, GdkEvent* ev)
{
  CLASS* bar = NULL;
  // widget name generation failed
  if(!owner->GenerateWidgetName(buff,VDK_WIDGET,&CLASS::Counter))
    // unauthorized operation
    return 2; 
  else
    bar = new CLASS(buff,owner);
  // add widget to form
  return owner->AddToSelf(bar,ev);
}
/*
This is called by a global CreateSource() in vdkb_parser.cc.
CreateSource() scans a table that maps class names with
each static CreateSource() in widget class.
 */
char*
CLASS::CreateSource(char* buffer,VDKBParser& parser)
{
  char* source;
  char obj_name[128];
  char obj_parent[128];
  char arg[64];
  char tmp[256];
  double min = 0.0,
    max = 1.0;
  // gets widget name and parent name
  if(! parser.GetNameAndParent(buffer, obj_name, obj_parent))
    return NULL;
  // get default values
  if(parser.GetParam(arg,buffer,PROP_BARMIN))
    min = atof(arg);
  if(parser.GetParam(arg,buffer,PROP_BARMAX))
    max = atof(arg);
  source = new char[4096];
  sprintf(tmp,"\n%s = new %s(this,%f,%f);",
	  obj_name,
	  VDK_CLASS,
	  min,
	  max);
  strcpy(source,tmp);
  
  ///////////////////////////////////////
  // call ancestor to set common properties
  char* props = VDKBObject::CreateSource(buffer,parser,obj_name);
  if(props)
    {
      strcat(source,props);
      delete[] props;
    }

  if(parser.GetParam(arg,buffer,PROP_BARBLOCKCOUNT) && 
     strcmp(arg,NIHIL_PROP))
   {
     sprintf(tmp,"\n%s->%s =  %s;",
	     obj_name,BARBLOCKCOUNT,arg);
     strcat(source,tmp);
   }    
  if(parser.GetParam(arg,buffer,PROP_BARSTYLE) && 
     strcmp(arg,NIHIL_PROP))
   {
     sprintf(tmp,"\n%s->%s = %s;",obj_name,BARSTYLE,arg);
     strcat(source,tmp);
   }    
  if(parser.GetParam(arg,buffer,PROP_BARORIENTATION) && 
     strcmp(arg,NIHIL_PROP))
   {
     sprintf(tmp,"\n%s->%s = %s;",
	     obj_name,BARORIENTATION,arg);
     strcat(source,tmp);
   }    
  if(parser.GetParam(arg,buffer,PROP_BARACTIVITYMODE) && 
     strcmp(arg,NIHIL_PROP))
   {
     sprintf(tmp,"\n%s->%s = %s;",
	     obj_name,BARACTIVITYMODE,arg);
     strcat(source,tmp);
   }    
  // get code that adds widget to container
  parser.WriteCodeToPack(obj_parent,obj_name,source,buffer,tmp);
  /*
    visible property must be wrote after adding it to a parent
    container. That's the reason why is written here and not
    in vdkb_object class as should be. Written only if == false
  */
  parser.WriteVisible( obj_name, arg, source,buffer,  tmp);
  return source;
}
/*
Invoked by VDKBGuiForm::MakeGuiObjects() during gui creation
reading .frm file.
MakeGuiObjects() scans .frm file and call a global CreateWidget()
that scans a table that maps class names with
each static CreateWidget() in widget class.
*/
bool
CLASS::CreateWidget(VDKBGuiForm* owner, 
			      char* buffer,VDKBParser& parser)
{
  char obj_name[128];
  char obj_parent[128];
  double min = 0.0,
    max = 1.0;
  char arg[64];
  CLASS* bar;
  // get widget name and parent
  if(! parser.GetNameAndParent(buffer, obj_name, obj_parent))
     return false;
  // get default values
  if(parser.GetParam(arg,buffer,PROP_BARMIN))
    min = atoi(arg);
  if(parser.GetParam(arg,buffer,PROP_BARMAX))
    max = atof(arg);
  VDKObject* p = owner->ChildWithName(obj_parent);
  VDKBEventContainer* container = p ? 
    dynamic_cast<VDKBEventContainer*>(p) : (VDKBEventContainer*) NULL;
  if(container)
    {
      bar = new CLASS(obj_name,owner,min,max);

      // prepares packing args based on those loaded by 
      if(parser.GetParam(arg,buffer,PROP_BARBLOCKCOUNT) && 
	 strcmp(arg,NIHIL_PROP))
	{
	  bar->SetBlockCount(atoi(arg));
	  bar->SetPropValue(BARBLOCKCOUNT,arg);
	}
      if(parser.GetParam(arg,buffer,PROP_BARSTYLE) && 
	 strcmp(arg,NIHIL_PROP))
	{
	  bar->SetBarStyle( atoi(arg));
	  bar->SetPropValue(BARSTYLE,arg);
	}
      if(parser.GetParam(arg,buffer,PROP_BARORIENTATION) && 
	 strcmp(arg,NIHIL_PROP))
	{
	  bar->SetBarOrientation( atoi(arg));
	  bar->SetPropValue(BARORIENTATION,arg);
	}
      if(parser.GetParam(arg,buffer,PROP_BARACTIVITYMODE) && 
	 strcmp(arg,NIHIL_PROP))
	{
	  bar->SetActivityMode(atoi(arg));
	  bar->SetPropValue(BARACTIVITYMODE,arg);
	}
      // pack widget to container
      return owner->PackToSelf(bar, container, buffer, parser);
    }
  else
    return false;

}
/////////////////////////////////////////////////////
//           OBJECT INSPECTOR MANAGEMENT
////////////////////////////////////////////////////
char* pstyles[] = {"continuous","discrete",0};
char* porient[] = { "left to right","right to left",
		    "bottom to top","top to bottom", 0};
/*
 */
VDKObjectContainer* 
CLASS::ExtraWidget(VDKBObjectInspector* isp) 
{ 
  inspector = isp;
  VDKLabelButton* button;
  int bc=0,t=0;
  VDKFrame* bframe = new VDKFrame(inspector,NULL,
				  v_box,shadow_etched_in);

  VDKTable *table = new VDKTable(inspector,6,2);
  table->SetSize(219,-1);

  table->AddToCell(new VDKLabel(inspector,"Minimum value"),0,0);
  min = new VDKEntry(inspector,0,(char*) GetProp(BARMIN));
  min->SetSize(100,-1);
  table->AddToCell(min,0,1);
  min->Parent(this);
  SignalConnect(min,"activate",&CLASS::OnSetMin);

  table->AddToCell(new VDKLabel(inspector,"Maximum value"),1,0);
  max = new VDKEntry(inspector,0,(char*) GetProp(BARMAX));
  max->SetSize(100,-1);
  table->AddToCell(max,1,1);
  max->Parent(this);
  SignalConnect(max,"activate",&CLASS::OnSetMax);

  button = new VDKLabelButton(inspector,"Set BlockCount");
  table->AddToCell(button,2,0);
  button->Parent(this);
  SignalConnect(button,"clicked",&CLASS::OnSetBlockCount);
  bc = atoi( (char*) GetProp("BlockCount"));
  blockcount = new VDKSpinButton(inspector, bc, 0, 100 , 1 ,0 );
  blockcount->SetSize(100,-1);
  table->AddToCell(blockcount,2,1);

  button = new VDKLabelButton(inspector,"Set bar style");
  table->AddToCell(button,3,0);
  SignalConnect(button,"clicked",&CLASS::OnSetBarStyle);
  button->Parent(this);
  bc = atoi( (char*) GetProp(BARSTYLE));
  barstyle = new VDKCombo(inspector,NULL);
  barstyle->SetSize(100,-1);
  StringList sl;
  for(t = 0;pstyles[t];t++)
    sl.add(VDKString(pstyles[t]));
  barstyle->PopdownStrings = sl;
  barstyle->SelectItem(bc);
  table->AddToCell(barstyle,3,1);

  sl.flush();
  button = new VDKLabelButton(inspector,"Set orientation");
  table->AddToCell(button,4,0);
  SignalConnect(button,"clicked",&CLASS::OnSetBarOrient);
  button->Parent(this);
  bc = atoi( (char*) GetProp(BARORIENTATION));
  barorient = new VDKCombo(inspector,NULL);
  barorient->SetSize(100,-1);
  for(t=0;porient[t];t++)
    sl.add(VDKString(porient[t]));
  barorient->PopdownStrings = sl;
  barorient->SelectItem(bc);
  table->AddToCell(barorient,4,1);

  activitymode = new VDKCheckButton(inspector,"Activity mode");
  table->AddToCell(activitymode,5,1);
  activitymode->Parent(this);
  SignalConnect(activitymode,"toggled",
		&CLASS::OnSetActivityMode);
  bframe->Add(table,l_justify,false,false,false);
  return bframe; 
}

/*
 */
bool
CLASS::OnSetMin(VDKObject*)
{
  if(strlen(min->Text) > 0)
    SetPropValue(BARMIN,(char*) min->Text);
  inspector->FormNeedToBeChanged();
  return true;
}
/*
 */
bool
CLASS::OnSetMax(VDKObject*)
{
  if(strlen(max->Text) > 0)
    SetPropValue(BARMAX,(char*) max->Text);
  inspector->FormNeedToBeChanged();
  return true;
}
/*
 */
bool
CLASS::OnSetBlockCount(VDKObject*)
{
  sprintf(buff,"%d",(int) blockcount->ValueAsInt);
  SetPropValue(BARBLOCKCOUNT,buff);
  inspector->FormNeedToBeChanged();
  return true;
}
/*
 */
bool
CLASS::OnSetBarStyle(VDKObject*)
{
  int sel = barstyle->Selected;
  sprintf(buff,"%d", sel >= 0 ? sel : 0);
  int style = atoi(buff);
  SetPropValue(BARSTYLE,buff);
  SetBarStyle(style);
  inspector->FormNeedToBeChanged();
  return true;
}
/*
 */
bool
CLASS::OnSetBarOrient(VDKObject*)
{
  int sel = barorient->Selected;
  sprintf(buff,"%d", sel >= 0 ? sel : 0);
  int orient = atoi(buff);
  SetPropValue(BARORIENTATION,buff);
  SetBarOrientation( orient);
  inspector->FormNeedToBeChanged();
  return true;
}

/*
 */
bool
CLASS::OnSetActivityMode(VDKObject*)
{
  SetPropValue(BARACTIVITYMODE, 
	       activitymode->Checked ? CHECK_TRUE : CHECK_FALSE);
  SetActivityMode( activitymode->Checked ? true : false);
  inspector->FormNeedToBeChanged();
  return true;
}


