/*
 * ===========================
 * VDK Builder
 * Version 0.1
 * Revision 0.0
 * November 1998
 * ===========================
 *
 * Copyright (C) 1998,1999 Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 *
 * Based on VDK Library 
 * Copyright (C) 1998, Mario Motta <mmotta@guest.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 *
 */

#include <vdkb/vdkb_logo.h>
#include <vdkb/vdkb.h>
#include <config.h>

DEFINE_SIGNAL_MAP(VDKBLogo,VDKForm)
  ON_SIGNAL(timer,timer_tick_signal,OnTimer)
END_SIGNAL_MAP
static char buff[256];
/*
 */
VDKBLogo::VDKBLogo(VDKForm* owner):
  VDKForm(owner,NULL,v_box,GTK_WINDOW_POPUP)
{
}
/*
 */
VDKBLogo::~VDKBLogo() {}
/*
 */
void
VDKBLogo::Setup()
{
  //  struct stat info;
  gtk_window_position(GTK_WINDOW(Window()),GTK_WIN_POS_CENTER);
  VDKFrame* frame = new VDKFrame(this);
  frame->BorderWidth(5);
  //VDKBuilder* app = (VDKBuilder*) Application();
  //sprintf(buff,"%s/.vdkb/%s",(char*) app->user_home,VDKB_LOGO);
  //if (stat(buff,&info) == -1)
  sprintf(buff,"%s/%s",VDKB_DATADIR,VDKB_LOGO);
  frame->Add(new VDKPixmap(this,buff,"Image manipulated with GIMP"));
  sprintf(buff,"VDK %d.%d.%d - Gtk+ %d.%d.%d - glib %d.%d.%d",
	  VDK_VERSION_MAJOR,
	  VDK_VERSION_MINOR,
	  VDK_REVISION,
	  gtk_major_version,
	  gtk_minor_version,
	  gtk_micro_version,
	  glib_major_version,
	  glib_minor_version,
	  glib_micro_version);

  frame->Add(new VDKLabel(this,buff,GTK_JUSTIFY_CENTER));
  timer = new VDKTimer(this,4000,true);
  Add(frame);
}

/*
 */
bool
VDKBLogo::OnTimer(VDKObject*)
{
Close();
return true;
}


