/*
 * ===========================
 * VDK Visual Development Kit
 * Version 0.6.1
 * March 1999
 * ===========================
 *
 * Copyright (C) 1998, Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 */
#include <vdkb/colorcombo.h>
void 
VDKColorComboBox::OnChange(GtkWidget *wid, 
			   gint i, gchar *color_name, gpointer gp)
{
  g_return_if_fail(wid != NULL);
  g_return_if_fail(gp != NULL);
  /* a little trick here:
     we must stop signal since callback args do not match
     with those defined for dynamic tables.
     User should connect with this signal using
     SignalConnect(<object>,"changed",false);
     so no real connection will be made.
     Or using static tables.
     
   */
  gtk_signal_emit_stop_by_name(GTK_OBJECT(wid),"changed");
  VDKColorComboBox* obj = reinterpret_cast<VDKColorComboBox*>(gp);
  obj->Canvas->NormalBackground = VDKRgb(color_name); 
  obj->Canvas->Clear(); 
  gtk_widget_draw(obj->Canvas->Widget(),NULL); 
  obj->SelectedColor(VDKString(color_name));
  obj->SignalEmitParent(changed_signal);
  obj->SignalEmit("changed");
}
/*
 */
VDKColorComboBox::VDKColorComboBox(VDKForm* owner):
  VDKCustomComboBox(owner),
  SelectedColor("SelectedColor",this,"")
{
  widget = sigwid = gtk_color_combo_new();
  gtk_widget_set_usize(GTK_WIDGET(GTK_COMBO_BOX(widget)->button),30,25);
  VDKBox* buttonbox = new VDKBox(owner,h_box);
  Canvas = new VDKCanvas(owner,20,20);
  buttonbox->Add(Canvas);
  gtk_container_add(GTK_CONTAINER(GTK_COMBO_BOX(widget)->button),
		   GTK_WIDGET(buttonbox->Widget()));
  AddItem(buttonbox);
  buttonbox->Visible = true;
  gtk_signal_connect(GTK_OBJECT(widget),
		     "changed", (GtkSignalFunc) OnChange, this);
}






