/*
 * ===========================
 * VDK Builder
 * Version 0.1
 * Revision 0.0
 * November 1998
 * ===========================
 *
 * Copyright (C) 1998,1999 Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 *
 * Based on VDK Library 
 * Copyright (C) 1998, Mario Motta
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 *
 */
#ifndef _vdkb_ide_def_h
#define _vdkb_ide_def_h
#include <stdio.h>
#include <string.h>
#include <sys/stat.h>
#include <unistd.h>
#include <vdk/vdk.h>
#include <vdkb/vdkb_types.h>
// default file parser
// sections
#define END_SECTION       "}"
#define EDITOR_SECTION    "vdkb_editor{"
#define UNIT_SECTION      "vdkb_units{"
#define PROJECT_SECTION   "vdkb_project{"
// keys
#define END_KEY             ";"
// editor keys
#define FONT_KEY            "font:"
#define FG_KEY              "fg:"
#define BG_KEY              "bg:"
#define EDITOR_HSIZE_KEY    "h_size:"
#define EDITOR_VSIZE_KEY    "v_size:"

#define EDITOR_COMMENT_COLOR_KEY "comment_color:"
#define EDITOR_CHARS_CONST_COLOR_KEY   "chars_const_color:"
#define EDITOR_STRING_CONST_COLOR_KEY  "string_const_color:"
#define EDITOR_KEY_COLOR_KEY     "key_color:"
#define EDITOR_PREPROCESS_COLOR_KEY "preprocess_color:"

#define EDITOR_COMMENT_FONT_KEY "comment_font:"
#define EDITOR_CHARS_CONST_FONT_KEY   "chars_const_font:"
#define EDITOR_STRING_CONST_FONT_KEY  "string_const_font:"
#define EDITOR_KEY_FONT_KEY     "key_font:"
#define EDITOR_KEY_TIMEDSAVE    "timed_save:"
#define EDITOR_KEY_BACKUP       "backup:"
#define EDITOR_KEY_TAB          "tab:"
// unit keys
#define UNIT_COUNT_KEY      "count:"
#define UNIT_NAME_KEY       "name:"
#define UNIT_CC_EXT_KEY     "cc_ext:"
#define UNIT_H_EXT_KEY      "h_ext:"
// project keys
#define PROJECT_COUNT_KEY   "count:"
#define PROJECT_NAME_KEY    "name:"
#define PROJECT_PRJ_EXT_KEY "prj_ext:"
#define PROJECT_HIDE_ON_RUN_KEY "hide_on_run:"
#define PROJECT_AUTOSAVE_KEY "autosave:"
#define PROJECT_STARTUPDIR_KEY "startup_dir:"
#define PROJECT_WI_RESIZEABLE_KEY "wi_resizeable:"
// defaults of defaults
// editor
#define EDITOR_DEF_SIZE VDKPoint(500,400)
#define EDITOR_DEF_FONT fnCourier12
#define EDITOR_DEF_FG   "black"
#define EDITOR_DEF_BG   "white"

#define EDITOR_DEF_COMMENT_COLOR "IndianRed4"
#define EDITOR_DEF_CHARS_COLOR  "red"
#define EDITOR_DEF_STRING_COLOR  "blue"
#define EDITOR_DEF_KEY_COLOR "IndianRed4"
#define EDITOR_DEF_PREPROCESS_COLOR "ForestGreen"

#define EDITOR_DEF_COMMENT_FONT "-*-courier-medium-o-*-*-12-*-*-*-*-*-*-*"
#define EDITOR_DEF_CHARS_FONT  "-*-courier-medium-r-*-*-12-*-*-*-*-*-*-*"
#define EDITOR_DEF_STRING_FONT  "-*-courier-medium-r-*-*-12-*-*-*-*-*-*-*"
#define EDITOR_DEF_KEY_FONT "-*-courier-bold-r-*-*-12-*-*-*-*-*-*-*"
#define EDITOR_DEF_TIMEDSAVE    "0"
#define EDITOR_DEF_BACKUP       "yes"
#define EDITOR_DEF_TAB          "4"
// unit
#define UNIT_DEF_COUNT  1
#define UNIT_DEF_NAME   (char*) "unit"
#define UNIT_DEF_CC_EXT (char*) ".cc"
#define UNIT_DEF_H_EXT  (char*) ".h"
// project
#define PROJECT_DEF_COUNT  1
#define PROJECT_DEF_NAME   (char*) "project"
#define PROJECT_DEF_PRJ_EXT (char*) ".prj"
#define PROJECT_DEF_HIDE_ON_RUN (char*) "no"
#define PROJECT_AUTOSAVE (char*) "no"
#define PROJECT_STARTUPDIR (char*) "home"
#define PROJECT_WI_RESIZEABLE (char*) "no"
/////// for project ///////////////
class VDKBProjectDefaults
{
 public:
  int count;
  VDKString def_name,prj_ext,hide_on_run,autosave,startupdir,wi_resizeable;
 public:
  VDKBProjectDefaults():
    count(PROJECT_DEF_COUNT),
    def_name(PROJECT_DEF_NAME),
    prj_ext(PROJECT_DEF_PRJ_EXT),
    hide_on_run(PROJECT_DEF_HIDE_ON_RUN),
    autosave(PROJECT_AUTOSAVE),
    startupdir(PROJECT_STARTUPDIR),
    wi_resizeable(PROJECT_WI_RESIZEABLE)
    {}
  void LoadDefaults(char* section);
  ~VDKBProjectDefaults() {}
};
/////// for editor ////////////////

class VDKBEditorDefaults
{
 public:  
  VDKString font, fg, bg;
  VDKPoint  size;
  VDKString comment_color,chars_const_color,string_const_color,
    key_color, preprocess_color, comment_font, chars_const_font,
    string_const_font, key_font,timedsave,backup, tab;
 public:
  VDKBEditorDefaults(): 
    font(EDITOR_DEF_FONT), 
    fg(EDITOR_DEF_FG), 
    bg(EDITOR_DEF_BG),
    size(EDITOR_DEF_SIZE),
    comment_color(EDITOR_DEF_COMMENT_COLOR),
    chars_const_color(EDITOR_DEF_CHARS_COLOR),
    string_const_color(EDITOR_DEF_STRING_COLOR),
    key_color(EDITOR_DEF_KEY_COLOR),
    preprocess_color(EDITOR_DEF_PREPROCESS_COLOR),
    comment_font(EDITOR_DEF_COMMENT_FONT),
    chars_const_font(EDITOR_DEF_CHARS_FONT),
    string_const_font(EDITOR_DEF_STRING_FONT),
    key_font(EDITOR_DEF_KEY_FONT),
    timedsave(EDITOR_DEF_TIMEDSAVE),
    backup(EDITOR_DEF_BACKUP),
    tab(EDITOR_DEF_TAB)
    {}
  void LoadDefaults(char* section);
  ~VDKBEditorDefaults() {}
};
///// for units ///////////////
class VDKBUnitDefaults
{
 public:
  int count;
  VDKString def_name,cc_ext,h_ext;
 public:
  VDKBUnitDefaults():
    count(UNIT_DEF_COUNT),
    def_name(UNIT_DEF_NAME),
    cc_ext(UNIT_DEF_CC_EXT),
    h_ext(UNIT_DEF_H_EXT) {}
  void LoadDefaults(char* section);
  ~VDKBUnitDefaults() {}
};
////////// all defaults /////////////
class VDKBDefaults
{
  VDKString rcFile;
 public:
  VDKBEditorDefaults editor;
  VDKBUnitDefaults unit;
  VDKBProjectDefaults project;
  //
  VDKBDefaults(char* resFile = NULL);
  void LoadDefaults(char* home);
  ~VDKBDefaults() {}
};
////////
#endif
