/*
   Written by Pieter J. Schoenmakers <tiggr@ics.ele.tue.nl>

   Copyright (C) 1996 Pieter J. Schoenmakers.

   This file is part of TOM.  TOM is distributed under the terms of the
   TOM License, a copy of which can be found in the TOM distribution; see
   the file LICENSE.

   $Id: OTMType.h,v 1.39 1998/04/06 11:56:40 tiggr Exp $  */

#import "OTMTop.h"

@interface OTMType: OTMTop
{
}

-(void) compileDeclaration;

/* Return YES iff the type is an object type.  Default is NO.  */
-(BOOL) isObjectType;

/* Return YES iff the receiving type is a tuple type.  Default is NO.  */
-(BOOL) isTuple;

/* Return YES, except for the any type.  */
-(BOOL) isFullyDefinedType;

/* Return YES iff the type T is an allowed type for a redeclaration of an
   argument to a method, which was originally declared with the previous
   type.  Iff SUBCLASS_P, the redeclaration is in a subclass.  Otherwise,
   it is a (re-)declaration in the same class.  */
-(BOOL) allowedTypeForArgumentRedeclaration: (OTMType *) t
				 inSubclass: (BOOL) subclass_p;

/* Compare the receiving type with the type tuple T.  */
-equalTypeTuple: (OTMTypeTuple *) t;

/* Return YES if the receiving type matches the type T.  Chars do not
   match ints, in this case, but all objects match all objects.  */
-(BOOL) matches: (OTMType *) t;

/* Return the match of the receiving type with the type T.  If both types
   are objects, and one of them is a superclass of the other, the super is
   returned.  With no match, return NIL.  */
-(OTMType *) matchesExactly: (OTMType *) t;

/* Like matchesExactly.  Default returns NIL.  */
-(OTMType *) matchesExactlyMeta: (OTMMeta *) t;

/* Return = 0 if the receiving type exactly matches the type T.  Return >
   0 if the type T can be widened to match.  In this case, the higher the
   absolute value returned, the more information is lost.  Thus, 0 implies
   an exact match.  Example: an int matches a char, but more information
   is lost than when the int were matched to a short.

   Return < 0 otherwise, implying narrowing or something else which is not
   a valid implicit cast.  */
-(int) matchesConvertibly: (OTMType *) t;

/* Prototype for subclasses (this is actually a deferred method.  */
-(id <TLString>) typeName;

/* Iff INDEX < 0, return the type proper.  For tuple types, if INDEX >= 0,
   return the type of that element, as indexed by the INDICES.  If INDEX
   >= 0, return NIL for non-tuple types or for tuple types for which the
   index is out of range.  */
-(OTMType *) typeAt: (int) index in: (int *) indices;

/* Return the name of the type as it is to appear in output mangled method
   names.  */
-(id <TLString>) frobnicatedName;

/* Like `-frobnicatedName', but make tuples indiscernable.  */
-(id <TLString>) flatFrobnicatedName;

/* Return the number of elements in the tuple type, or 1 for a non-tuple.  */
-(int) elementCount;

/* Return the number of transitive non-tuple elements in the type.  */
-(int) flatElementCount;

#if 0
/* Return the type of a function in the output language which returns the
   receiving type.  */
-(id <TLString>) outputFunctionTypeForType;
#endif

/* Return the name of this type as output, i.e. in the output language.  */
-(id <TLString>) outputTypeName;

/* Return the comma separated output type name of the receiving type or
   its elements.  */
-(id <TLString>) outputCastName;

/* Return the TRT_TE_* encoding name of this type.  */
-(id <TLString>) outputTypeEncoding;

/* Output the output declaration of the receiving type, if necessary.  */
-(id) precompile;

/* Return the type, unless it is a tuple with a single element, in which
   case to return that element.  */
-(OTMType *) tupleSingleElement;

/* Return the first non-tuple element, recursively.  Returns SELF for
   non-tuple types.  */
-(OTMType *) tupleFirstFlatElement;

-(id <TLString>) typeInfo;

/* Return YES iff the receiving type can be validly cast to the argument
   TYPE.  Default is NO, unless TYPE is the same object as the receiver.  */
-(BOOL) validCastTo: (OTMType *) type;

/* Return the alignment, in bits, required by the type.  Tuple types can
   ignore this.  */
-(int) minimumAlignment;

@end
