/*
   Written by Pieter J. Schoenmakers <tiggr@ics.ele.tue.nl>

   Copyright (C) 1997 Pieter J. Schoenmakers.

   This file is part of TOM.  TOM is distributed under the terms of the
   TOM License, a copy of which can be found in the TOM distribution; see
   the file LICENSE.

   $Id: OTMAliasAlias.m,v 1.3 1998/01/05 01:11:53 tiggr Exp $  */

#define OTMALIASALIAS_DECLARE_PRIVATE_METHODS
#import "OTMAliasAlias.h"

@implementation OTMAliasAlias

+(OTMAliasAlias *) aliasWithExtension: (OTMExtension *) x
				 name: (id <TLString>) n
				 type: (OTMType *) t
{
  return [[self gcAlloc] initWithExtension: x name: n type: t];
}

-(OTMExtension *) extension
{
  return ext;
}

-(void) gcReference
{
  MARK (ext);
  MARK (name);

  [super gcReference];
}

-(id) initWithExtension: (OTMExtension *) x
		   name: (id <TLString>) n
		   type: (OTMType *) t
{
  if (![super initWithType: t])
    return nil;

  ext = x;
  name = n;

  return self;
}

-(id <TLString>) name
{
  return name;
}

@end
