<copyright> MutableIntArray class.
    Written by <a href="mailto:tiggr@ics.ele.tue.nl">Pieter J. Schoenmakers</a>

    Copyright &copy; 1995-1997 Pieter J. Schoenmakers.

    This file is part of TOM.  TOM is distributed under the terms of the
    TOM License, a copy of which can be found in the TOM distribution; see
    the file LICENSE.

    <id>$Id: MutableIntArray.t,v 1.7 1998/01/05 01:06:44 tiggr Exp $</id>
    </copyright>

implementation class
MutableIntArray: IntArray, MutableArray

end;

implementation instance
MutableIntArray

void
  add int i
{
  [self set i at length];
}

void
  freeze
{
  //  isa = [IntArray self];
}

extern id
  initWithCapacity int capacity;

protected id
  initWithEnumerator Enumerator e
{
  [super (IntArray) initWithEnumerator e];

  capacity = length;

  = self;
}

extern int
  removeAt int index;

Any
  removeAt int index
{
  int i = [self removeAt index];

  = Any ([IntNumber with i]);
}

extern void 
  removeElements (int, int) (start, length);

extern void
  resize (int, int) (start, num);

extern void
  set int i
   at int index;

void
  set All object
   at int index
{
  self[index] = [Number (object) intValue];
}

extern void
  swap (int, int) (i, j);

end;
