<copyright> CharArray class.
    Written by <a href="mailto:tiggr@ics.ele.tue.nl">Pieter J. Schoenmakers</a>

    Copyright &copy; 1995-1997 Pieter J. Schoenmakers.

    This file is part of TOM.  TOM is distributed under the terms of the
    TOM License, a copy of which can be found in the TOM distribution; see
    the file LICENSE.

    <id>$Id: CharArray.t,v 1.25 1998/01/05 01:05:26 tiggr Exp $</id>
    </copyright>

<doc> Like the {ByteArray}, the {CharArray} is a particular kind of
    {Array}, which is here for abstraction purposes, but which is never
    actually used, since the {CharString} holds the same kind of state,
    but provides much more functionality.  </doc>
implementation class
CharArray: Array

end;

implementation instance
CharArray

Any
  at int index
{
  byte b = self[index];

  = Any ([ByteNumber with b]);
}

extern byte
  at int index;

<doc> Return the char value at {index}.  This is the elementary retrieval
    method for character arrays.  </doc>
extern char
  at int index;

int
  at int index
{
  char c = self[index];

  = c;
}

long
  at int index
{
  char c = self[index];

  = c;
}

float
  at int index
{
  char c = self[index];

  = float (c);
}

double
  at int index
{
  char c = self[index];

  = double (c);
}

extern int
  elementByteSize;

protected extern id
  initWithEnumerator Enumerator e;

extern  (pointer, int)
  pointerToElements (int, int) (start, len);

/******************** copying ********************/
<doc> <h4>Copying</h4> </doc>

<doc> Return the {MutableCharArray} class.  </doc>
class (State)
  mutableCopyClass
{
  = [MutableCharArray self];
}

end;
