/* C style buffer management.
   This file is part of TL, Tiggr's Library.
   Written by Tiggr <tiggr@es.ele.tue.nl>
   Copyright (C) 1995, 1996 Pieter J. Schoenmakers
   TL is distributed WITHOUT ANY WARRANTY.
   See the file LICENSE in the TL distribution for details.

   $Id: buffer.h,v 1.1 1998/01/08 16:13:49 tiggr Exp $  */

#import "support.h"

typedef struct tlbuffer
{
  /* The storage space.  */
  char *buf;

  /* CAP is the maximum number of bytes the buffer can hold.  NUM is the
     number of bytes it actually holds.  */
  int cap, num;
} tlbuffer;

#define TLBUFFER_BUF(BUF)		((BUF)->buf)
#define TLBUFFER_CAP(BUF)		((BUF)->cap)
#define TLBUFFER_NUM(BUF)		((BUF)->num)
#define TLBUFFER_SET_NUM(BUF, NUM)	((BUF)->num = (NUM))

__TL_INLINE__ void
tlbuffer_dealloc (tlbuffer *buf)
{
  xfree (buf->buf);
} /* tlbuffer_dealloc */

__TL_INLINE__ void
tlbuffer_ensure_space (tlbuffer *buf, int space)
{
  if (buf->cap < buf->num + space)
    {
      buf->cap += buf->num + space;
      buf->buf = xrealloc (buf->buf, buf->cap);
    }
} /* tlbuffer_ensure_space */

__TL_INLINE__ void
tlbuffer_grow_if_needed (tlbuffer *buf, int space)
{
  if (buf->cap < buf->num + space)
    {
      buf->cap = buf->cap ? 2 * buf->cap : 16;
      buf->buf = xrealloc (buf->buf, buf->cap);
    }
} /* tlbuffer_grow_if_needed */

__TL_INLINE__ void
tlbuffer_init (tlbuffer *buf)
{
} /* tlbuffer_init */
