(define (fannkuch-1 n perm perm1 zaehl permmax)
 (define (fill p n)
  (do ((i 0 (+ i 1))) ((>= i n))
   (vector-set! p i i)))
 (define (vector-copy1 perm perm1 n)
  (do ((i 0 (+ i 1))) ((>= i n))
   (vector-set! perm i (vector-ref perm1 i))))
 (define (vector-copy2 perm perm1 n)
  (do ((i 0 (+ i 1))) ((>= i n))
   (vector-set! perm i (vector-ref perm1 i))))
 (define (flip k k2 perm n)
  (do ((i 0 (+ i 1))) ((>= i k2))
   (let* ((temp (vector-ref perm i))
	  (j (- k i)))
    (vector-set! perm i (vector-ref perm j))
    (vector-set! perm j temp))))
 (define (kreuz-loop zaehl r)
  (if (not (= r 1))
      (let ((i (- r 1)))
       (vector-set! zaehl i r)
       (kreuz-loop zaehl i))))
 (define (shift r perm1 n)
  (let ((perm0 (vector-ref perm1 0)))
   (let loop ((i 0))
    (if (not (= i r))
	(let ((k (+ i 1)))
	 (vector-set! perm1 i (vector-ref perm1 k))
	 (loop k))))
   (vector-set! perm1 r perm0)))
 (define (count-flips perm n)
  (let loop ((count 0))
   (let ((k (vector-ref perm 0)))
    (cond ((= k 0) count)
	  (else (flip k (quotient (+ k 1) 2) perm n)
		(loop (+ count 1)))))))
 (fill perm1 n)
 (let main ((bishmax -1)
	    (r n))
  (kreuz-loop zaehl r)
  (if (not (or (= (vector-ref perm1 0) 0)
	       (let ((i (- n 1))) (= (vector-ref perm1 i) i))))
      (begin (vector-copy1 perm perm1 n)
	     (let ((count (count-flips perm n)))
	      (if (> count bishmax)
		  (begin (set! bishmax count)
			 (vector-copy2 permmax perm1 n))))))
  (let loop ((r 1))
   (cond ((= r n) bishmax)
	 (else (shift r perm1 n)
	       (let ((i (- (vector-ref zaehl r) 1)))
		(vector-set! zaehl r i)
		(if (<= i 0) (loop (+ r 1)) (main bishmax r))))))))

(define (fannkuch n)
 (fannkuch-1 n
	     (make-vector n)
	     (make-vector n)
	     (make-vector n)
	     (make-vector n)))

(do ((i 0 (+ i 1))) ((= i 100))
 (write (fannkuch 10))
 (newline))
