/*
 * RT-Linux FIFOs
 *
 *  Copyright (C) 1999 FSM Labs (http://www.fsmlabs.com/)
 *  Written by Michael Barabanov <baraban@fsmlabs.com>
 */

#ifndef __RTF__
#define __RTF__

#ifdef __KERNEL__


extern int rtf_init(void);



/* attach a handler to an RT-FIFO
 *
 * Allow function \arg{handler} to be called when a user process reads or
 * writes to the FIFO. When the function is called, it is passed the fifo
 * number as the argument.
 */

extern int rtf_create_handler(unsigned int fifo,	/* RT-FIFO */
		int (*handler)(unsigned int fifo)	/* function to be called */);



/* create an RT-FIFO
 * 
 * An RT-FIFO \arg{fifo} is created with initial size of \arg{size}.
 * 
 * Return value: On success,  \arg{size} is returned. On error, -1 is returned.
 */

extern int rtf_create(unsigned int fifo, int size);



/* destroy an RT-FIFO
 * 
 * Return value: On success, 0 is returned
 */

extern int rtf_destroy(unsigned int fifo);



/* resize an RT-FIFO
 * 
 * Return value: \arg{size} is returned on success. On error, a negative value
 * is returned
 * 
 * Bugs: This operation destroys the contents of the FIFO
 */

extern int rtf_resize(unsigned int minor, int size);



/*
 * write to an RT-FIFO
 *
 * Try to write \arg{count} bytes to an FIFO.  Return -1 if there's not enough space
 * in the FIFO; otherwise return \arg{count}
 */

extern int rtf_put(unsigned int fifo,	/* RT-FIFO */
		void * buf,		/* buffer address */
	       	int count		/* number of bytes to write */);



/*
 * read from an RT-FIFO
 *
 * Try to read \arg{count} bytes from a FIFO.
 * Return -1 if there's not enough data in the FIFO; 
 * otherwise return \arg{count}
 */
extern int rtf_get(unsigned int fifo,	/* RT-FIFO */
		void * buf, 		/* buffer address */
		int count		/* number of bytes to read */);


#define RTFSETSIZE 0
#define RTFMMAPABLE 1

#endif

#endif
