#ifndef __RTL_CORE_H__
#define __RTL_CORE_H__

#ifdef MODULE
/* we're compiling for the native RTL */

#include <asm/ptrace.h>
#include <linux/rtl.h>
#include <linux/sched.h>

typedef unsigned long rtl_irqstate_t;

extern void rtl_hard_enable_irq(unsigned int ix);
extern void rtl_hard_disable_irq(unsigned int ix);

#define rtl_free_soft_irq(irq) free_irq(irq, 0)

#ifdef __SMP__
extern int request_ipi (unsigned int (*f)(struct pt_regs *r), int cpu);
extern int free_ipi (int cpu);
#endif

#ifdef __SMP__
#define rtl_getcpuid() hard_smp_processor_id()
#define rtl_num_cpus() (smp_num_cpus)
#else
#define rtl_getcpuid() 0
#define rtl_num_cpus() 1
#endif


#include <rtl_conf.h>
#include <linux/cons.h>

#else
/* user-mode emulation of the RTL environment */

#include <stdio.h>
#include <stdarg.h>

static int rtl_printf(const char *fmt, ...)
{
	va_list list;
	int ret;
	va_start (list, fmt);
	ret = vprintf(fmt, list);
	va_end (list);
	return ret;
}


#endif


#endif
