#ifndef MODULE
#define MODULE
#endif
#include <linux/module.h>
#include <linux/kernel.h>
#include <linux/version.h>
#include <linux/errno.h>
#include <linux/cons.h>

#include <rtl_sched.h>
#include <rtl_fifo.h>
#include "control.h"

RT_TASK tasks[2];

static char *data[] = {"Frank ", "Zappa "};

/* t -- the fifo number */
void fun(int t) {
	while (1) {
/* 		conpr(t - 1 ? "0" : "1"); */
		conprll (rt_get_time()); conpr("\n");
/* 		rtf_put(t, data[t - 1], 6); */
		rt_task_wait();
	}
}


int my_handler(unsigned int fifo)
{
	struct my_msg_struct msg;
	int err;
	RTIME now;

	while ((err = rtf_get(3, &msg, sizeof(msg))) == sizeof(msg)) {
		switch (msg.command) {
			case START_TASK:
				now = rt_get_time();
				rt_task_make_periodic(&tasks[msg.task], now, msg.period);
				break;
			case STOP_TASK:
				rt_task_suspend(&tasks[msg.task]);
				break;
			default:
				return -EINVAL;
		}
	}
	if (err != 0) {
		return -EINVAL;
	}
	return 0;
}


int init_module(void)
{
	RTIME now;
	now = rt_get_time();
	rt_task_init(&tasks[0], fun, 1, 3000, 4);
	rt_task_init(&tasks[1], fun, 2, 3000, 5);
	rt_task_make_periodic(&tasks[0], now, 500 * 10000);
/* 	rt_task_make_periodic(&tasks[1], now, 200 * 1000000); */
	return 0;
}


void cleanup_module(void)
{
	rt_task_delete(&tasks[0]);
	rt_task_delete(&tasks[1]);
}
