/* test FP operations in RT tasks */

#include <linux/module.h>
#include <linux/kernel.h>
#include <linux/version.h>
#include <rtl.h>
#include <time.h>
#include <asm/io.h>

#include <pthread.h>
#include <math.h>

pthread_t mytask;
pthread_t task2;
pthread_t task3;

void *fun (void *t)
{
	int i = 0;
	double f = 0;
	while (1) {
		pthread_wait_np();
/* 		conpr(t == 1 ? "1" : "2"); */
		i++;
		f++;
		if (i != f) {
			conpr("Task "); conprn ((int) t);
			conpr(" FP error: i = "); conprn(i);
			conpr("f = "); conprn(f); conpr("\n");
			i = 0;
			f = 0;
		}
		if (i > 200000) {
			i = 0;
			f = 0;
		}
	}
/* 	conpr("The RT-task has stopped.\n"); */
}


void *ifun (void *t)
{
	int i=0;
	while (1) {
		pthread_wait_np();
/* 		conpr("i"); */
		if (i++ % 5000 == 0) {
		}
	}
}


int init_module (void)
{
	struct sched_param p;
	hrtime_t now = gethrtime();

	pthread_create (&mytask, NULL, fun, (void *) 1);
	pthread_make_periodic_np (mytask, now + 2 * NSECS_PER_SEC, 31230000);
	pthread_setfp_np (mytask, 1);
	p . sched_priority = 1;
	pthread_setschedparam (mytask, SCHED_FIFO, &p);

	pthread_create (&task2, NULL, fun, (void *) 2);
	pthread_make_periodic_np (task2, now + 2 * NSECS_PER_SEC, 50000000);
	pthread_setfp_np (task2, 1);
	p . sched_priority = 2;
	pthread_setschedparam (task2, SCHED_FIFO, &p);

	pthread_create (&task3, NULL, ifun, (void *) 3);
	pthread_make_periodic_np (task3, now + 2 * NSECS_PER_SEC, 30000000);
	pthread_setfp_np (task3, 1);
	p . sched_priority = 3;
	pthread_setschedparam (task3, SCHED_FIFO, &p);

	return 0;
}


void cleanup_module (void)
{
	pthread_delete_np (mytask);
	pthread_delete_np (task2);
	pthread_delete_np (task3);
}

