/*
 * Copyright (c) 1999 The University of Utah and the Flux Group.
 * All rights reserved.
 * 
 * Contributed by the Computer Security Research division,
 * INFOSEC Research and Technology Office, NSA.
 * 
 * This file is part of the Flux OSKit.  The OSKit is free software, also known
 * as "open source;" you can redistribute it and/or modify it under the terms
 * of the GNU General Public License (GPL), version 2, as published by the Free
 * Software Foundation (FSF).  To explore alternate licensing terms, contact
 * the University of Utah at csl-dist@cs.utah.edu or +1-801-585-3271.
 * 
 * The OSKit is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GPL for more details.  You should have
 * received a copy of the GPL along with the OSKit; see the file COPYING.  If
 * not, write to the FSF, 59 Temple Place #330, Boston, MA 02111-1307, USA.
 */
/* FLASK */

#ifndef _SERVICES_H_
#define _SERVICES_H_

int security_compute_av(
	security_id_t ssid,			/* IN */
	security_id_t tsid,			/* IN */
	security_class_t tclass,		/* IN */
	access_vector_t requested,		/* IN */
	access_vector_t *allowed,		/* OUT */
	access_vector_t *decided,		/* OUT */
#ifdef CONFIG_FLASK_AUDIT
	access_vector_t *auditallow,		/* OUT */
	access_vector_t *auditdeny,		/* OUT */
#endif
#ifdef CONFIG_FLASK_NOTIFY
	access_vector_t *notify,	       	/* OUT */
#endif
	unsigned int *seqno);			/* OUT */

int security_transition_sid(
	security_id_t ssid,			/* IN */
	security_id_t tsid,			/* IN */
	security_class_t tclass,		/* IN */
	security_id_t *out_sid);	        /* OUT */

int security_member_sid(
	security_id_t ssid,			/* IN */
	security_id_t tsid,			/* IN */
	security_class_t tclass,		/* IN */
	security_id_t *out_sid);	        /* OUT */

int security_sid_to_context(
	security_id_t  sid,			/* IN */
	security_context_t *scontext,		/* OUT */
	unsigned int   *scontext_len);		/* OUT */

int security_context_to_sid(
	security_context_t scontext,		/* IN */
	unsigned int   scontext_len,		/* IN */
	security_id_t *out_sid);		/* OUT */

int security_load_policy(FILE * fp);

int security_load_extension(security_id_t parent,  /* IN */
			    FILE *fp);

int security_sid_to_econtext(
        security_id_t  sid,             /* IN */
        security_context_t *scontext,   /* OUT */
        unsigned int   *scontext_len,   /* OUT */
	security_econtext_t *econtext,  /* OUT */
	unsigned int   *econtext_len);  /* OUT */

int security_econtext_to_sid(
        security_context_t scontext,    /* IN */
        unsigned int   scontext_len,    /* IN */
	security_econtext_t econtext, 	/* IN */
	unsigned int   econtext_len, 	/* IN */
        security_id_t *sid);             /* OUT */

#include "policydb.h"
#include "sidtab.h"
#include "extavtab.h"
#include "exttrtab.h"

extern int ss_root_context_valid(ss_root_context_t *context, 
				 policydb_t *p,
				 int *rc);

extern sidtab_t sidtab;
extern policydb_t policydb;
extern extavtab_t extavtab;
extern exttrtab_t exttrtab;
extern int ss_initialized;

#endif _SERVICES_H_

/* FLASK */
