/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.metal;

import com.sun.java.swing.JButton;
import com.sun.java.swing.JComponent;
import com.sun.java.swing.JToolBar;
import com.sun.java.swing.border.Border;
import com.sun.java.swing.plaf.ComponentUI;
import com.sun.java.swing.plaf.UIResource;
import com.sun.java.swing.plaf.basic.BasicToolBarUI;
import com.sun.java.swing.plaf.metal.MetalButtonBorder;
import com.sun.java.swing.plaf.metal.MetalButtonUI;
import com.sun.java.swing.plaf.metal.MetalRolloverButtonBorder;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.Hashtable;

public class MetalToolBarUI
extends BasicToolBarUI
implements ContainerListener {
    protected static Border rolloverBorder = new MetalRolloverButtonBorder();
    protected static Border nonRolloverBorder = new MetalButtonBorder();
    protected Hashtable borderTable = new Hashtable();
    protected ContainerListener contListener;
    private boolean rolloverBorders = false;
    private PropertyChangeListener rolloverListener;
    protected static String IS_ROLLOVER = "JToolBar.isRollover";

    public static ComponentUI createUI(JComponent jComponent) {
        return new MetalToolBarUI();
    }

    public void installUI(JComponent jComponent) {
        this.rolloverListener = new RolloverListener();
        jComponent.addPropertyChangeListener(this.rolloverListener);
        super.installUI(jComponent);
        Object object = jComponent.getClientProperty(IS_ROLLOVER);
        if (object != null) {
            this.setRolloverBorders((Boolean)object);
            return;
        }
        this.setRolloverBorders(false);
    }

    public void uninstallUI(JComponent jComponent) {
        jComponent.removePropertyChangeListener(this.rolloverListener);
        super.uninstallUI(jComponent);
        this.installNormalBorders(jComponent);
    }

    protected void installListeners(JComponent jComponent) {
        super.installListeners(jComponent);
        this.contListener = this.createContainerListener(jComponent);
        if (this.contListener != null) {
            jComponent.addContainerListener(this.contListener);
        }
    }

    protected void uninstallListeners(JComponent jComponent) {
        super.uninstallListeners(jComponent);
        if (this.contListener != null) {
            jComponent.removeContainerListener(this.contListener);
            this.contListener = null;
        }
    }

    protected ContainerListener createContainerListener(JComponent jComponent) {
        return this;
    }

    protected BasicToolBarUI.DockingListener createDockingListener(JToolBar jToolBar) {
        return new MetalDockingListener(jToolBar);
    }

    protected void setDragOffset(Point point) {
        if (this.dragWindow == null) {
            this.dragWindow = this.createDragWindow(this.toolBar);
        }
        this.dragWindow.setOffset(point);
    }

    public boolean isRolloverBorders() {
        return this.rolloverBorders;
    }

    public void setRolloverBorders(boolean bl) {
        this.rolloverBorders = bl;
        if (this.rolloverBorders) {
            this.installRolloverBorders(this.toolBar);
            return;
        }
        this.installNonRolloverBorders(this.toolBar);
    }

    protected void installRolloverBorders(JComponent jComponent) {
        Component[] componentArray = jComponent.getComponents();
        int n = 0;
        while (n < componentArray.length) {
            if (componentArray[n] instanceof JComponent) {
                ((JComponent)componentArray[n]).updateUI();
                this.setBorderToRollover(componentArray[n]);
            }
            ++n;
        }
    }

    protected void installNonRolloverBorders(JComponent jComponent) {
        Component[] componentArray = jComponent.getComponents();
        int n = 0;
        while (n < componentArray.length) {
            if (componentArray[n] instanceof JComponent) {
                ((JComponent)componentArray[n]).updateUI();
                this.setBorderToNonRollover(componentArray[n]);
            }
            ++n;
        }
    }

    protected void installNormalBorders(JComponent jComponent) {
        Component[] componentArray = jComponent.getComponents();
        int n = 0;
        while (n < componentArray.length) {
            this.setBorderToNormal(componentArray[n]);
            ++n;
        }
    }

    protected void setBorderToRollover(Component component) {
        JButton jButton;
        if (component instanceof JButton && (jButton = (JButton)component).getUI() instanceof MetalButtonUI) {
            if (jButton.getBorder() instanceof UIResource) {
                this.borderTable.put(jButton, jButton.getBorder());
            }
            if (jButton.getBorder() instanceof UIResource || jButton.getBorder() == nonRolloverBorder) {
                jButton.setBorder(rolloverBorder);
            }
            jButton.setRolloverEnabled(true);
        }
    }

    protected void setBorderToNonRollover(Component component) {
        JButton jButton;
        if (component instanceof JButton && (jButton = (JButton)component).getUI() instanceof MetalButtonUI) {
            if (jButton.getBorder() instanceof UIResource) {
                this.borderTable.put(jButton, jButton.getBorder());
            }
            if (jButton.getBorder() instanceof UIResource || jButton.getBorder() == rolloverBorder) {
                jButton.setBorder(nonRolloverBorder);
            }
            jButton.setRolloverEnabled(false);
        }
    }

    protected void setBorderToNormal(Component component) {
        JButton jButton;
        if (component instanceof JButton && (jButton = (JButton)component).getUI() instanceof MetalButtonUI) {
            if (jButton.getBorder() == rolloverBorder || jButton.getBorder() == nonRolloverBorder) {
                jButton.setBorder((Border)this.borderTable.remove(jButton));
            }
            jButton.setRolloverEnabled(false);
        }
    }

    public void componentAdded(ContainerEvent containerEvent) {
        Component component = containerEvent.getChild();
        if (this.rolloverBorders) {
            this.setBorderToRollover(component);
            return;
        }
        this.setBorderToNonRollover(component);
    }

    public void componentRemoved(ContainerEvent containerEvent) {
        Component component = containerEvent.getChild();
        this.setBorderToNormal(component);
    }

    class RolloverListener
    implements PropertyChangeListener,
    Serializable {
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if (string.equals(IS_ROLLOVER)) {
                if (propertyChangeEvent.getNewValue() != null) {
                    MetalToolBarUI.this.setRolloverBorders((Boolean)propertyChangeEvent.getNewValue());
                    return;
                }
                MetalToolBarUI.this.setRolloverBorders(false);
            }
        }

        RolloverListener() {
            MetalToolBarUI.this = MetalToolBarUI.this;
        }
    }

    protected class MetalDockingListener
    extends BasicToolBarUI.DockingListener {
        protected boolean pressedInBumps = false;

        public MetalDockingListener(JToolBar jToolBar) {
            super(jToolBar);
            MetalToolBarUI.this = MetalToolBarUI.this;
        }

        public void mousePressed(MouseEvent mouseEvent) {
            super.mousePressed(mouseEvent);
            MetalToolBarUI.this.setDragOffset(mouseEvent.getPoint());
            this.pressedInBumps = false;
            Rectangle rectangle = new Rectangle();
            if (this.toolBar.getSize().height <= this.toolBar.getSize().width) {
                rectangle.setBounds(0, 0, 14, this.toolBar.getSize().height);
            } else {
                rectangle.setBounds(0, 0, this.toolBar.getSize().width, 14);
            }
            if (rectangle.contains(mouseEvent.getPoint())) {
                this.pressedInBumps = true;
            }
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            if (this.pressedInBumps) {
                super.mouseDragged(mouseEvent);
            }
        }
    }
}

