/*
 *
 * Copyright 1998-1999, University of Notre Dame.
 * Authors: Jeffrey M. Squyres, Kinis L. Meyer with M. D. McNally 
 *          and Andrew Lumsdaine
 *
 * This file is part of the Notre Dame LAM implementation of MPI.
 *
 * You should have received a copy of the License Agreement for the
 * Notre Dame LAM implementation of MPI along with the software; see
 * the file LICENSE.  If not, contact Office of Research, University
 * of Notre Dame, Notre Dame, IN 46556.
 *
 * Permission to modify the code and to distribute modified code is
 * granted, provided the text of this NOTICE is retained, a notice that
 * the code was modified is included with the above COPYRIGHT NOTICE and
 * with the COPYRIGHT NOTICE in the LICENSE file, and that the LICENSE
 * file is distributed with the modified code.
 *
 * LICENSOR MAKES NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED.
 * By way of example, but not limitation, Licensor MAKES NO
 * REPRESENTATIONS OR WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY
 * PARTICULAR PURPOSE OR THAT THE USE OF THE LICENSED SOFTWARE COMPONENTS
 * OR DOCUMENTATION WILL NOT INFRINGE ANY PATENTS, COPYRIGHTS, TRADEMARKS
 * OR OTHER RIGHTS.  
 *
 * Additional copyrights may follow.
 *
 *	Ohio Trollius
 *	Copyright 1996 The Ohio State University
 *	GDB
 *
 *	$Id: rpwait.c,v 6.3 1999/06/16 05:54:54 jsquyres Exp $
 * 
 *	Function:	- waits for kenya process to die
 *			- based on Trollius 2.0 Copyright 1990
 *			  The Ohio State University and Cornell
 *			  Research Foundation
 *
 *	Accepts:	- ptr to node ID
 *			- ptr to process ID
 *			- ptr to child process status
 *
 *	Returns:	- 0 or ERROR with errno set accordingly
 */

#include <unistd.h>

#include <net.h>
#include <portable.h>
#include <preq.h>
#include <t_types.h>
#include <typical.h>

int
rpwait(nodeid, pid, status)

int4			*nodeid;
int			*pid;
int			*status;

{
	struct nmsg	nhead;		/* network message descriptor */
	struct preply	reply;		/* kenyad reply */

	nhead.nh_event = (-getpid()) & 0xBFFFFFFF;
	nhead.nh_type = 1;
	nhead.nh_flags = 0;
	nhead.nh_length = sizeof(struct preply);
	nhead.nh_msg = (char *) &reply;

	if (nrecv(&nhead)) {
		return(ERROR);
	}

	*nodeid = ttol(reply.pr_nodeid);
	*pid = (int) ttol(reply.pr_pid);
	*status = (int) ttol(reply.pr_reply);

	return(0);
}
