/*
 *
 * Copyright 1998-1999, University of Notre Dame.
 * Authors: Jeffrey M. Squyres, Kinis L. Meyer with M. D. McNally 
 *          and Andrew Lumsdaine
 *
 * This file is part of the Notre Dame LAM implementation of MPI.
 *
 * You should have received a copy of the License Agreement for the
 * Notre Dame LAM implementation of MPI along with the software; see
 * the file LICENSE.  If not, contact Office of Research, University
 * of Notre Dame, Notre Dame, IN 46556.
 *
 * Permission to modify the code and to distribute modified code is
 * granted, provided the text of this NOTICE is retained, a notice that
 * the code was modified is included with the above COPYRIGHT NOTICE and
 * with the COPYRIGHT NOTICE in the LICENSE file, and that the LICENSE
 * file is distributed with the modified code.
 *
 * LICENSOR MAKES NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED.
 * By way of example, but not limitation, Licensor MAKES NO
 * REPRESENTATIONS OR WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY
 * PARTICULAR PURPOSE OR THAT THE USE OF THE LICENSED SOFTWARE COMPONENTS
 * OR DOCUMENTATION WILL NOT INFRINGE ANY PATENTS, COPYRIGHTS, TRADEMARKS
 * OR OTHER RIGHTS.  
 *
 * Additional copyrights may follow.
 *
 *	Ohio Trollius
 *	Copyright 1997 The Ohio State University
 *	RBD/GDB
 *
 *	$Id: ssend.c,v 6.8 1999/11/12 05:19:33 jsquyres Exp $
 *
 *	Function:	- synchronous send
 *	Accepts:	- buffer
 *			- count
 *			- datatype
 *			- destination
 *			- tag
 *			- communicator
 *	Returns: 	- MPI_SUCCESS or error code
 */

#include <lam_config.h>
#include <blktype.h>
#include <mpi.h>
#include <mpisys.h>
#include <rpisys.h>
#include <debug.h>
#if LAM_WANT_IMPI
#include <impi.h>
#endif

/*
 * local variables
 */
static int fl_debug = 0;


int
MPI_Ssend(buf, count, dtype, dest, tag, comm)

void			*buf;
int			count;
MPI_Datatype		dtype;
int			dest;
int			tag;
MPI_Comm		comm;

{
	int		err;
#if LAM_WANT_IMPI 
	MPI_Request     req;
#endif

	lam_initerr_m();
	lam_setfunc_m(BLKMPISSEND);

	if (tag < 0 || tag > LAM_MAXTAG) {
		return(lam_errfunc(comm, BLKMPISSEND,
				lam_mkerr(MPI_ERR_TAG, 0)));
	}

	err = lam_send(buf, count, dtype, dest, tag, comm, LAM_RQISSEND);

	if (err != MPI_SUCCESS) return(lam_errfunc(comm, BLKMPISSEND, err));

#if LAM_WANT_IMPI
/*
 * If this is to the IMPID, we need to wait for a *second* ACK --
 * because the ssend will complete when the IMPID receives our
 * original message.  We need to wait for the IMPI to ACK back to us
 * saying that the remote side has sent back the ack
 * (IMPI_PK_SYNCACK).  [Mis-]Use the shadow communicator for this so
 * that we don't interfere with the real message.
 */
	IMPI_Register_ping(dest, tag, comm, &req);
	if (req != MPI_REQUEST_NULL) {
	  req->rq_marks |= LAM_RQFMAND;
	  req->rq_hdlr = 0;
	  DBUG("LAM rank waiting for SYNCACK\n");
	  MPI_Wait(&req, MPI_STATUS_IGNORE);
	  DBUG("LAM rank got SYNCACK from remote host\n");
	}
#endif

	lam_resetfunc_m(BLKMPISSEND);
	return(MPI_SUCCESS);
}
