%
% Copyright (C) 1997 Thomas Nordin and Alastair Reid
%

\begin{code}

module Target( Target(..) ) where

data Target 
  = GHC_casm
  | GHC_ccall
  | FFI
  | NHC
  | Hugs
    deriving (Eq) -- needed by Proc.genProc.mkResult

instance Show Target where
  showsPrec d t =
   case t of
     NHC       -> showString "NHC"
     Hugs      -> showString "Hugs"
     GHC_ccall -> showString "GHC{-ccall-}"
     GHC_casm  -> showString "GHC{-casm-}"
     FFI       -> showString "FFI"
\end{code}
