/* (-*-c++-*-)
 * Time-stamp: <98/04/16 10:44:20 panic>
 * Authors:  The C-mix Team
 * Content:  C-Mix system: write constraints (for read-only analysis)
 *
 * Copyright  1998. The TOPPS group at DIKU, U of Copenhagen.
 * Redistribution and modification are allowed under certain
 * terms; see the file COPYING.cmix for details.
 */

#ifndef __WRCONSTRAINT_C__
#define __WRCONSTRAINT_C__

#include "ALoc.h"
#include <map.h>
#include "Plist.h"
#include "fix.h"
#include "options.h"

#define roadebug (debugstream_roa)
extern DebugStream roadebug;

class WriteConstraint: public AbstractConstraint {
public:
  typedef map<ALocSet*, Plist<WriteConstraint>*, IDcompare >
          globalMapType;
private:
  ALocSet* superset;
  ALocSet* subset;
  globalMapType* subset2constraints;
  unsigned long ID;
  static unsigned long nextID;
public:
  WriteConstraint(globalMapType* gm, ALocSet* sup, ALocSet* sub) :
    superset(sup), subset(sub), subset2constraints(gm),
    ID(nextID++) { };
  virtual bool update() {
    assert(subset != NULL);
    assert(superset != NULL);
    unsigned int presize = superset->size();
    if (roadebug ^ 3) roadebug
      << "updating " << *this << "\n";
    for (ALocSet::iterator i = subset->begin();
	 i != subset->end(); i++)
      superset->insert(*i);
    return presize != superset->size();
  }
  Plist<WriteConstraint>* succs() {
    return (*(subset2constraints->find(superset))).second;
  }
  virtual void initSuccs() {
      Plist<WriteConstraint>* Succs = succs();
      FOREACH(i,Succs,WriteConstraint)
          one_successor(*i);
  }
  virtual void show(ostream& s);
};

unsigned long WriteConstraint::nextID = 0;

void WriteConstraint::show(ostream& s) {
  s << "[" << ID << ":" << *superset << ">=" << *subset << ":";
  Plist<WriteConstraint>* cs = succs();
  Plist<WriteConstraint>::iterator i = cs->begin();
  if (i != cs->end()) { s << (*i)->ID; i++; }
  for (; i != cs->end(); i++) {
    s << "," << (*i)->ID;
  }
  s << "]";
}

#endif
