------------------------------------------------------------------------------
--                                                                          --
--                 ASIS-for-GNAT IMPLEMENTATION COMPONENTS                  --
--                                                                          --
--                           A 4 G . C _ U _ I N F O                        --
--                                                                          --
--                                 B o d y                                  --
--                                                                          --
--            Copyright (c) 1995-1999, Free Software Foundation, Inc.       --
--                                                                          --
-- ASIS-for-GNAT is free software; you can redistribute it and/or modify it --
-- under terms of the  GNU General Public License  as published by the Free --
-- Software Foundation;  either version 2,  or  (at your option)  any later --
-- version. ASIS-for-GNAT is distributed  in the hope  that it will be use- --
-- ful, but WITHOUT ANY WARRANTY; without even the implied warranty of MER- --
-- CHANTABILITY or  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General  --
-- Public License for more details. You should have received a copy of the  --
-- GNU General Public License  distributed with ASIS-for-GNAT; see file     --
-- COPYING. If not, write to the Free Software Foundation,  59 Temple Place --
-- - Suite 330,  Boston, MA 02111-1307, USA.                                --
--                                                                          --
-- As a special exception,  if other files  instantiate  generics from this --
-- unit, or you link  this unit with other files  to produce an executable, --
-- this  unit  does not  by itself cause  the resulting  executable  to  be --
-- covered  by the  GNU  General  Public  License.  This exception does not --
-- however invalidate  any other reasons why  the executable file  might be --
-- covered by the  GNU Public License.                                      --
--                                                                          --
-- ASIS-for-GNAT was originally developed  by the ASIS-for-GNAT team at the --
-- Software  Engineering  Laboratory  of  the Swiss  Federal  Institute  of --
-- Technology (LGL-EPFL) in Lausanne,  Switzerland, in cooperation with the --
-- Scientific  Research  Computer  Center of  Moscow State University (SRCC --
-- MSU), Russia,  with funding partially provided  by grants from the Swiss --
-- National  Science  Foundation  and  the  Swiss  Academy  of  Engineering --
-- Sciences.  ASIS-for-GNAT is now maintained by  Ada Core Technologies Inc --
-- (http://www.gnat.com).                                                   --
--                                                                          --
------------------------------------------------------------------------------


with Asis.Set_Get;    use  Asis.Set_Get;
with A4G.Vcheck;      use A4G.Vcheck;
with A4G.Contt;       use A4G.Contt;
with A4G.Contt.UT;    use A4G.Contt.UT;

with Atree;           use Atree;
with Sinfo;           use Sinfo;
with Lib;             use Lib;
with Namet;

package body A4G.C_U_Info is

   LT : String renames ASIS_Line_Terminator;

   --------------------
   -- Enclosing_Unit --
   --------------------

   function Enclosing_Unit
     (Cont : Context_Id; Node : Node_Id)
      return Asis.Compilation_Unit
   is
      Current_Node   : Node_Id := Node;
      Result_Unit_Id : Unit_Id := Nil_Unit;
      Success        : Boolean := False;
   begin
      --  first, checking if we are or are not in the package Standard:
      if Sloc (Node) <= Standard_Location then
         Result_Unit_Id := Standard_Id;
      else
         --  we are not in the package Standard here, therefore we have to
         --  find the top node of the enclosing subtree:
         while not (Nkind (Current_Node) = N_Compilation_Unit) loop
            pragma Assert (Present (Parent (Current_Node)));
            Current_Node := Parent (Current_Node);
         end loop;

         --  now - getting the normalized unit name
         Namet.Get_Decoded_Name_String (Lib.Unit_Name (
                      Get_Cunit_Unit_Number (Current_Node)));

         Set_Norm_Ada_Name_String_With_Check
           (Get_Cunit_Unit_Number (Current_Node), Success);

         if Success then
            Result_Unit_Id := Name_Find (Cont);
         end if;

      end if;

      if No (Result_Unit_Id) then
         Raise_ASIS_Failed (Diagnosis =>
            "A4G.C_U_Info.Enclosing_Unit: Nil_Unit is returned "
          & "as an Enclosing Unit " & LT & "for Node "
          &  Node_Id'Image (Node)
          & " Context Id: "
          &  Context_Id'Image (Cont)
          & " tree accessed: "
          & Tree_Id'Image (Get_Current_Tree));

      else
         return Get_Comp_Unit (Result_Unit_Id, Cont);
      end if;
   end Enclosing_Unit;

end A4G.C_U_Info;