/*
 * file_mod.c -- Trivial module for reading simple, plain files
 *
 * Copyright (c) 1997 by Roman Hodek <Roman.Hodek@informatik.uni-erlangen.de>
 * Modified by Nick Holgate to support VME file I/O.
 *
 * This file is subject to the terms and conditions of the GNU General Public
 * License.  See the file COPYING in the main directory of this archive
 * for more details.
 */

#include "loader.h"

/***************************** Prototypes *****************************/

static int mod_file_open( const char *name );
static long mod_file_fillbuf( void *buf );
static int mod_file_skip( long cnt );
static int mod_file_close( void );

/************************* End of Prototypes **************************/

#define MAXBUF	(32*1024)

/* definition of the module structure */
MODULE file_mod = {
	"file",						/* name */
	MAXBUF,						/* maxbuf (arbitrary) */
	mod_file_open,
	mod_file_fillbuf,
	mod_file_skip,
	mod_file_close,
	MOD_REST_INIT
};

/*--------------------------------------------------------------------------*/

static
int
mod_file_open
(	const char	*name
)
{
	percent_init(file_size(name));

	return file_open(name);
}

/*--------------------------------------------------------------------------*/

static
long
mod_file_fillbuf
(	void	*buf
)
{	long	rv = file_read(buf, MAXBUF);
	percent_show(file_tell());
	return rv;
}

/*--------------------------------------------------------------------------*/

static
int
mod_file_skip
(	long	cnt
)
{	int		rv = file_seek(cnt, SEEK_CUR);
	percent_show(file_tell());
	return rv; 
}

/*--------------------------------------------------------------------------*/

static
int
mod_file_close
(	void
)
{
	file_close();
	return 0;
}

/*-----------------------------< end of file >------------------------------*/
