# copyright (C) 1997-1999 Jean-Luc Fontaine (mailto:jfontain@multimania.com)
# this program is free software: please read the COPYRIGHT file enclosed in this package or use the Help Copyright menu

set rcsId {$Id: menuhelp.tcl,v 2.1 1999/08/28 08:34:21 jfontain Exp $}

class menuContextHelp {

    proc menuContextHelp {this menu} {
        bind $menu <<MenuSelect>> "menuContextHelp::selected $this \$::tkPriv(activeItem)"
        ::set ($this,active) -1                                                             ;# corresponding to none: no active item
        ::set ($this,menu) $menu
    }

    proc ~menuContextHelp {this} {
        variable ${this}string

        bind $($this,menu) <<MenuSelect>> {}
        catch {unset ${this}string}
    }

    proc set {this item string} {
        variable ${this}string

        ::set ${this}string($item) $string
    }

    proc selected {this item} {
        variable ${this}string

        if {[string equal $item none]} {                                                                           ;# normalize item
            ::set item -1
        }
        if {$item==$($this,active)} return                                                                              ;# no change
        lifoLabel::pop $global::messenger
        if {$item>=0} {                                                                                     ;# replace with new item
            if {[catch {::set ${this}string($item)} string]} {
                lifoLabel::push $global::messenger $item                                     ;# display item number to aid debugging
            } else {
                lifoLabel::push $global::messenger $string
            }
        }
        ::set ($this,active) $item
    }

}
