/* ***********

   ***********
*/
#pragma implementation
#include <stdio.h>
#include <string.h>
#include <translat.h>
#include "mod_dnsconf.h"
#include "dnsconf.m"
#include <netconf.h>
#include <hostinfo.h>
#include <daemoni.h>
#include "dnsconf.h"

MODULE_DEFINE_VERSION(dnsconf);


PUBLIC MODULE_dnsconf::MODULE_dnsconf()
	: LINUXCONF_MODULE("dnsconf")
{
	linuxconf_loadmsg ("dnsconf",PACKAGE_REV);
	module_register_api ("dnsconf",1,dnsconf_api_get,dnsconf_api_release);
}


static const char *keymenu=NULL;

PUBLIC void MODULE_dnsconf::setmenu (
	DIALOG &dia,
	MENU_CONTEXT context)
{
	if (context == MENU_NETWORK_SERVER){
		keymenu = MSG_U(M_dnsconf,"Domain Name Server (DNS)");
		dia.new_menuitem ("dnsconf","",keymenu);
	}
}

PUBLIC int MODULE_dnsconf::domenu (
	MENU_CONTEXT context,
	const char *key)
{
	if (context == MENU_NETWORK_SERVER){
		if (key == keymenu){
			dnsconf_edit();
		}
	}
	return 0;
}


PUBLIC int MODULE_dnsconf::dohtml (const char *key)
{
	int ret = LNCF_NOT_APPLICABLE;
	if (strcmp(key,"dnsconf")==0){
		// ### Insert any menu and dialog here
		ret = 0;
	}
	return ret;
}
static HELP_FILE help_named_pid ("dnsconf","named_pid");
static CONFIG_FILE f_named_pid (VAR_RUN_NAMED_PID,help_named_pid
	,CONFIGF_PROBED|CONFIGF_OPTIONNAL);


/*
	Restart sendmail if ETC_SENDMAIL_CF is newer than the process
*/
static int dnsconf_startif ()
{
	int ret = -1;
	DAEMON_INTERNAL *dae = daemon_find ("named");
	if (dae != NULL){
		dae->setpidfile (&f_named_pid);
		DNS dns;
		long revdate = dns.getrevdate();
		long restart = dae->getrestarttime();
		bool problem;
		PROC *prc = dae->findprocess(problem);
		if (prc == NULL){
			if (revdate > 0){
				net_hint ("NAMED","start");
				ret = dae->start();
			}else{
				ret = 0;
			}
		}else{
			long start = prc->getstarttime();
			if (restart > start) start = restart;
			if (start < revdate){
				net_hint ("NAMED","restart");
				dae->restart();
			}else if (revdate <= 0){
				net_hint ("NAMED","stop");
				dae->stop();
			}
		}
	}
	return ret;
}

PUBLIC int MODULE_dnsconf::probe (
	int ,	// Current level being probed
			// Only service of this level should do something.
	int ,	// target network runlevel of the probe
			// In which runlevel the machine is going to be
			// after the probe has completed
	bool)	// simulation mode ?
{
	int ret = 0;
	// See the message() function below to understand how named is started
	if (simul_ishint()){
		ret = dnsconf_startif();
	}
	return ret;
	
}

/*
	Update the local DNS (if present) from the host information
*/
static void dnsconf_updatedns(HOSTINFO &info, int silent)
{
	if (dns_configured()){
		if (features_getsyncbasichost()){
			dns_load();
			const int nbdev = info.nbdev;
			const char *tbip[nbdev];
			int nbip = 0;
			int ok = 0;
			for (int i=0; i<nbdev; i++){
				INTER_INFO *itf = &info.a[i];
				if (!itf->ipaddr.is_empty()){
					const char *ip = itf->ipaddr.get();
					if (i == 0
						|| itf->name.is_empty()){
						tbip[nbip++] = ip;
					}else{
						const char *tb[1];
						tb[0] = ip;
						ok |= dnsconf_condset (itf->name.get(),tb,1);
					}
				}
			}
			if (nbip > 0 && !info.a[0].name.is_empty()){
				ok |= dnsconf_condset (info.a[0].name.get(),tbip,nbip);
			}
			dns_unload();
			if (ok && !silent){
				xconf_notice(MSG_U(N_DNSUPDATED,"The DNS has been updated (changed)"));
			}
		}
	}
}

void dnsconf_updatedns(bool silent)
{
	HOSTINFO info;
	if (netconf_loadinfos(info)!=-1){
		dnsconf_updatedns(info,silent);
	}
}


PUBLIC int MODULE_dnsconf::message (const char *msg, int, const char *[])
{
	int ret = LNCF_NOT_APPLICABLE;
	if (strcmp(msg,"updatedns")==0){
		dnsconf_updatedns (false);
		ret = 0;
	}else if (strcmp(msg,"startnamed")==0){
		// named is a critical applicaion and must be started at a specific
		// time, so we do not rely on the probe() function to start it.
		// In netconf/start.cc, we send a specific message "startnamed"
		// so the module may react in the proper sequence.
		ret = dnsconf_startif ();
	}
	return ret;
}

PUBLIC void MODULE_dnsconf::usage (SSTRINGS &tb)
{
	tb.add (new SSTRING (MSG_R(N_DNSUSAGE)));
}

PUBLIC int MODULE_dnsconf::execmain (int argc , char *argv[])
{
	int ret = LNCF_NOT_APPLICABLE;
	const char *pt = strrchr(argv[0],'/');
	if (pt != NULL){
		pt++;
	}else{
		pt = argv[0];
	}
	if (strcmp(pt,"dnsconf")==0){
		ret = dnsconf_main (argc,argv);
	}
	return ret;
}


static MODULE_dnsconf dnsconf;

