#pragma interface
#ifndef DHCPD_H
#define DHCPD_H

#ifndef MISC_H
	#include <misc.h>
#endif
#ifndef MODULE_H
	#include <module.h>
#endif

#include <modapi_def.h>
#include <modapi.h>

class MODULE_DHCPD: public LINUXCONF_MODULE{
	/*~PROTOBEG~ MODULE_DHCPD */
public:
	MODULE_DHCPD (void);
	int domenu (MENU_CONTEXT context, const char *key);
	int execmain (int argc, char *argv[]);
	int probe (int level, int , bool);
	void setmenu (DIALOG&dia, MENU_CONTEXT context);
	void usage (SSTRINGS&tb);
	/*~PROTOEND~ MODULE_DHCPD */
};

class DNSCONF_API;

#include <ipstuff.h>

struct COMBO_OPTION{
	char *val,*desc;
};


struct DHCP_PARSE{
	FILE *fin;
	char buf[1000];
	char *pt;
	int error;
	int eof;
	int noline;
	int offset_last;	// Offset into buf of the last token/word read
};

class DHCP_OPTION: public ARRAY_OBJ{
public:
	SSTRING keyw;
	SSTRINGS values;
	const char *title;		// Title for the dialog
	int maxvalues;			// Number of values accepted
	int section;
	const COMBO_OPTION *help;
	/*~PROTOBEG~ DHCP_OPTION */
public:
	DHCP_OPTION (const char *_keyw);
	DHCP_OPTION (void);
	void addvalue (const char *value);
private:
	void init (void);
public:
	void write (const char *indent, FILE *fout);
	/*~PROTOEND~ DHCP_OPTION */
};

class DHCP_OPTIONS: public ARRAY{
	/*~PROTOBEG~ DHCP_OPTIONS */
public:
	void fill (void);
	DHCP_OPTION *getitem (const char *keyw);
	DHCP_OPTION *getitem (int no);
	void setdia (DIALOG&dia);
	void unfill (void);
	void write (const char *indent, FILE *fout);
	/*~PROTOEND~ DHCP_OPTIONS */
};

class DHCP_RANGE: public ARRAY_OBJ{
public:
	char dyn_bootp;		// May allocate IP dynamicly to bootp client
	SSTRING alloc_start;
	SSTRING alloc_stop;
	/*~PROTOBEG~ DHCP_RANGE */
public:
	DHCP_RANGE (char _dyn_bootp,
		 SSTRING&_start,
		 SSTRING&_stop);
	DHCP_RANGE (void);
	/*~PROTOEND~ DHCP_RANGE */
};

class DHCP_RANGES: public ARRAY{
	/*~PROTOBEG~ DHCP_RANGES */
public:
	DHCP_RANGE *getitem (int no)const;
	/*~PROTOEND~ DHCP_RANGES */
};

class DHCP_SUBNET: public ARRAY{
public:
	SSTRING network;
	SSTRING netmask;
	DHCP_OPTIONS options;
	TIMESTR default_lease_time;
	TIMESTR max_lease_time;
	DHCP_RANGES ranges;
	/*~PROTOBEG~ DHCP_SUBNET */
public:
	DHCP_SUBNET (void);
	int edit (void);
	int read (DHCP_PARSE&par);
private:
	int readline (DHCP_PARSE&par);
	int readlines (DHCP_PARSE&par);
public:
	void write (FILE *fout);
	/*~PROTOEND~ DHCP_SUBNET */
};

class DHCP_SUBNETS: public ARRAY{
	/*~PROTOBEG~ DHCP_SUBNETS */
public:
	DHCP_SUBNET *getitem (int no);
	void write (FILE *fout);
	/*~PROTOEND~ DHCP_SUBNETS */
};

class DHCP_HOST: public ARRAY_OBJ{
public:
	SSTRING hardadr;	// Hardware address
	SSTRING proto;		// network
	SSTRING ip_host;	// IP number or host name
	DHCP_OPTIONS options;
	/*~PROTOBEG~ DHCP_HOST */
public:
	void write (const char *indent, FILE *fout);
	/*~PROTOEND~ DHCP_HOST */
};

class DHCP_HOSTS: public ARRAY{
public:
	/*~PROTOBEG~ DHCP_HOSTS */
public:
	DHCP_HOST *getitem (int no);
	void write (const char *indent, FILE *fout);
	/*~PROTOEND~ DHCP_HOSTS */
};

class DHCP_BOOTP: public ARRAY_OBJ{
public:
	DHCP_OPTIONS options;
	DHCP_HOSTS hosts;
	/*~PROTOBEG~ DHCP_BOOTP */
public:
	void write (FILE *fout);
	/*~PROTOEND~ DHCP_BOOTP */
};
class DHCP_BOOTPS: public ARRAY{
	/*~PROTOBEG~ DHCP_BOOTPS */
public:
	DHCP_BOOTP *getitem (int no);
	/*~PROTOEND~ DHCP_BOOTPS */
};

class DHCP{
public:
	SSTRING identifier;
	DHCP_SUBNETS subnets;
	DHCP_OPTIONS options;
	DHCP_BOOTPS bootps;
	TIMESTR default_lease_time;
	TIMESTR max_lease_time;
	int error;
	SSTRING dnsdom;		// Default domain to fill the DNS
	char cronupddns;	// Enable the update in cron
	/*~PROTOBEG~ DHCP */
public:
	DHCP (void);
	void edit (void);
private:
	int editdefaults (void);
public:
	void editloop (void);
	int probe (void);
private:
	int readline (DHCP_PARSE&par);
	int readlines (DHCP_PARSE&par);
public:
	int write (void);
	/*~PROTOEND~ DHCP */
};

class UWE_RANGE: public ARRAY_OBJ {
  IP_ADDR lo;
  IP_ADDR hi;
public:
  UWE_RANGE (const SSTRING& _lo, const SSTRING& _hi);
  int inrange (IP_ADDR* ipa);
};


class UWE_RANGES: public ARRAY {
public:
  UWE_RANGES(DHCP& dh);
  UWE_RANGE* getitem( int no);
  int inrange (IP_ADDRS& ips);
};

#include "dhcpd.p"

#endif

