#include <string.h> /* memset */
#include "internal.h"
#include "apache.m"

static APACHE_HELP_FILE help_apache ("apache");
static APACHE_HELP_FILE help_mod ("modules");
static APACHE_HELP_FILE help_perf ("performance");
static APACHE_HELP_FILE help_users ("users");

static HTTPD_CONFIG *httpd;

/* FIXME: Do the mapping like vhosts */

int HTTPD_USERS::cwrite()
{ 
	int ret = -1;
	CONFIG_FILE conf (file.get(),help_nil,CONFIGF_OPTIONAL|CONFIGF_MANAGED);
	FILE *fp = conf.fopen("w");
	if(fp != NULL) {
		int n = getnb();
		for(int i=0;i<n;i++) { 
			HTTPD_USER *u = getitem(i);
			if(!u->user.is_empty()) { 
				fprintf(fp,"%s:%s\n",u->user.get(),u->pass.get());
			}
		}
		ret = fclose(fp);
	}
	return ret;
}

int HTTPD_AUTHS::edit()
{	
	int ret = -1, nof = 0;

	while (1) {
		DIALOG dia;
		dia.newf_title ("",MSG_U(T_USERFILES,"Users configurations"));
		int n = getnb();
		for(int i=0;i<n;i++) {
			HTTPD_USERS *d = getitem(i);
			if (!d->file.is_empty()) 
				dia.new_menuitem("",d->file);
		}

		MENU_STATUS code = dia.editmenu (MSG_U(T_USERS,
					"Users configurations")
					,MSG_U(I_USERS,"You can configure Apache users/groups\n")
					,help_users
					,nof,0);

		nof--;

        if (code == MENU_ESCAPE || code == MENU_QUIT){
           break;
		}else if(code == MENU_ADD) { 
        }else if (nof < n && nof >= 0){
           ret = editone(nof);
        }

	}
	return ret;
}

PUBLIC int HTTPD_USERS::edit () { 

	int ret = 0, nof = 0; 


	ret = parsehtpasswd((char *)file.get(),*this); 
	
	if(ret == -1) return -1;

	while(1) {
		DIALOG dia;

		int usernum = getnb();

		for(int i=0;i<usernum; i++) {
			dia.new_menuitem("",getitem(i)->user.get());
		}

		dia.setbutinfo (MENU_USR1,MSG_U(B_CHANGEPASS,"Change Password"),"");

		MENU_STATUS code = dia.edit (
			MSG_U(T_APAUSER,"User Configuration")
			,MSG_U(I_APAUSER,"You can configure Apache Users") 
			,help_users
			,nof,MENUBUT_ACCEPT|MENUBUT_USR1|MENUBUT_ADD|MENUBUT_DEL);
		if (code == MENU_CANCEL || code == MENU_ESCAPE){
			break;
		}else if (code == MENU_ACCEPT){
			ret = 0;
			break;
		}else if (code == MENU_ADD){
			HTTPD_USER *u = new HTTPD_USER();
			add(u);		
			u->edit (*this);
		}else if(code == MENU_USR1){ 
			if(getitem(nof)->edit(*this) == 2)
				cwrite();
		}else if(code == MENU_ACCEPT) { 
			cwrite();
		}else if (code == MENU_DEL){
			if (xconf_delok()){
				remove_del(nof);
				ret = 1;
				cwrite();
				break;
			}
		}
	}
	return 0;
}


PUBLIC int HTTPD_USER::edit (HTTPD_USERS &users) { 
	int ret = -1, nof = 0;
	DIALOG dia;
	SSTRING repass, cpass;
	dia.newf_str(MSG_U(F_USER,"Username"),user);
	dia.newf_pass(MSG_U(F_PASS,"Password"),cpass);
	dia.newf_pass(MSG_U(F_REPASS,"Re-type password"),repass);

	while(1) { 
		MENU_STATUS code = dia.edit (
			MSG_U(T_APANAMEPASS,"User name/password")
			,MSG_U(I_APANAMEPASS,"You can configure user name/password") 
			,help_users
			,nof,MENUBUT_CANCEL|MENUBUT_ACCEPT);
		if (code == MENU_CANCEL || code == MENU_ESCAPE){
			break;
		}else if (code == MENU_ACCEPT){
			if(stricmp(cpass.get(),repass.get()) != 0)
			// FIXME: Translations
				xconf_error("Passwords dont match\n");
			else {
				pass.setfrom(cryptit((char *)pass.get()));
				return 2;
			}
		}
	}
	return ret;
}

int parsehtpasswd (const char *file, HTTPD_USERS &users)
{  
	char line[100], username[60], password[40];
	if(file == NULL) return -1;
	CONFIG_FILE conf (file,help_nil,CONFIGF_OPTIONAL);
	FILE *fp = conf.fopen("r");
	if (fp == NULL) return -1;

	users.remove_all();
	while(fgets(line,sizeof(line), fp) != NULL) {
		if(line[0] == '\n') break;
		int i = 0, a = 0;
		while(line[i] != ':') {
			username[i] = line[i];
			i++;
		}
		username[i] = '\0';
		
		i++; /* : */

		while(line[i] != '\n') {
			password[a] = line[i];
			i++, a++;
		}

		password[a] = '\0';
		HTTPD_USER *c = new HTTPD_USER();

		c->user.setfrom(username);
		c->pass.setfrom(password);
		users.add(c);
		
		memset(line,0,sizeof(line));
		memset(username,0,sizeof(username));
		memset(password,0,sizeof(password));
	}
	return 0;
}

PUBLIC int HTTPD_CONFIG::perfedit(HTTPD_CONFIG &_httpd)
{
	DIALOG dia;
	int ret = -1;
	httpd = &_httpd;
	int nof = 0;

	dia.newf_title ("",MSG_U(T_NRPROC,"Number of Processes"));

	dia.newf_num (MSG_U(F_STARTSERVERS,"Start servers"),startservers);
	dia.newf_num (MSG_U(F_MAXCLIENTS,"Max clients per servers"),maxclients);
	dia.newf_num (MSG_U(F_MAXREQUESTS,"Max requests per child"),
	maxrequestsperchild);
	dia.newf_num (MSG_U(F_MINSPARESERVERS,"Minimum of spare servers"),
	minspareservers);
	dia.newf_num (MSG_U(F_MAXSPARESERVERS,"Maximum of spare servers"),
	maxspareservers);

	dia.newf_title ("",MSG_U(T_KEEPSALIVE,"Keeps Alive"));

	dia.newf_chk   ("",keepalive,MSG_U(I_KEEPALIVE,"Keep Alive"));
	dia.newf_num (MSG_U(F_KEEPALIVET,"Keep Alive Timeout"),keepalive_timeout);
	dia.newf_num (MSG_U(F_MAXKEEPALIVEREQ,"Max Keep Alive Requests")
				,maxkeepalivereq);

	dia.newf_title ("",MSG_U(T_ADVTUNING,"Advanced Tuning"));

	dia.newf_num (MSG_U(F_TIMEOUT,"Time out"),timeout);

	while(1) {
		MENU_STATUS code = dia.edit (
			MSG_U(T_APAPERF,"Apache Performance Tuning")
			,MSG_U(I_APAPERF,"You can configure Apache performance")
			,help_perf
			,nof);
		if (code == MENU_CANCEL || code == MENU_ESCAPE){
			break;
		}else if (code == MENU_ACCEPT){
			ret = 0;
			httpd->write();
			break;
		}
	}

	if (ret == -1) dia.restore();
	return ret;
}

PUBLIC int HTTPD_CONFIG::modedit(HTTPD_CONFIG &_httpd) {
	DIALOG dia;
	int ret = -1;
	httpd = &_httpd;
	int nof = 0;
	while (1){
		int n = lmodules.getnb();
		for(int i=0;i<n;i++) {
			SSTRING *mod = lmodules.getitem(i);
			dia.newf_str ("",*mod);
		}
		MENU_STATUS code = dia.edit (
			MSG_U(T_APAMOD,"Apache Modules Configuration")
			,MSG_U(I_APAMOD,"You can configure modules that will be loaded by Apache")
			,help_mod
			,nof,MENUBUT_CANCEL|MENUBUT_ADD|MENUBUT_ACCEPT);
		if (code == MENU_CANCEL || code == MENU_ESCAPE){
			break;
		}else if (code == MENU_ACCEPT){
			ret = 0;
			httpd->write();
			break;
		}else if(code == MENU_ADD) {
			SSTRING *cs = new SSTRING;
			lmodules.add(cs);
		}

	}
	if (ret == -1) dia.restore();
	return ret;
}

PUBLIC void HTTPD_FEATURES::setdia (DIALOG &dia)
{
	dia.newf_title ("",MSG_U(T_FEATURES,"Features"));
	dia.newf_chk   ("",includes,MSG_U(I_INCLUDES,"Server side includes"));
	dia.newf_chk   ("",includesnoexec,MSG_U(I_INCLUDESNOEXEC,"IncludesNOEXEC"));
	dia.newf_chk   ("",execcgi,MSG_U(I_EXECCGI,"May execute CGI"));
	dia.newf_chk   ("",indexes,MSG_U(I_INDEXES,"Indexes"));
	dia.newf_chk   ("",followsymlinks,MSG_U(I_FOLLOWSYMLINK,"May follow symlinks"));
	dia.newf_chk   ("",symlinksifownermatch,MSG_U(I_FOLLOWOWNERSYMLINK
		,"Follow symlink if owner matches"));
	dia.newf_chk   ("",multiviews,MSG_U(I_MULTIVIEWS,"Multi views"));
}

PUBLIC void HTTPD_DOMOPT::setdia (
	DIALOG &dia,
	bool advanced)		// Show advanced features
{
	dia.newf_str (MSG_U(F_SERVERADMIN,"Administrator email"),serveradmin);
	dia.newf_str (MSG_U(F_IP,"Domain IP address"),namevhost);
	dia.newf_str (MSG_U(F_SERVERNAME,"Server name"),servername);
	dia.newf_str (MSG_U(F_DOCUMENTROOT,"Document root"),documentroot);
	dia.newf_str (MSG_U(F_ERRLOG,"Error log"),errorlog);
	dia.newf_str (MSG_U(F_TRANSFERLOG,"Transfer log"),transferlog);
	dia.newf_str (MSG_U(F_AGENTLOG,"Agent log"),agentlog);
	dia.newf_str (MSG_U(F_REFERERLOG,"Referer log"),refererlog);
	if (advanced){
		dia.newf_str (MSG_U(F_SCRIPTALIAS,"Script Alias"),scriptalias);
		dia.newf_str (MSG_U(F_SETUIDUSER,"CGI SetUID User"),setuiduser);
		dia.newf_str (MSG_U(F_SETUIDGROUP,"CGI SetUID Group"),setuidgroup);
	}

}

void ssl_setdia (DIALOG &dia, struct shared_ssl &opts, bool opt) {
	FIELD_COMBO *loglevel, *vercli, *proto;
	if(opt == true)	dia.newf_title ("",MSG_U(T_SSLOPTIONS,"SSL Options"));
	dia.newf_str (MSG_U(F_SSLCIPHERSUITE,"Cipher Suite"),opts.SSLCipherSuite);
	dia.newf_str (MSG_U(F_SSLCERTFILE,"Certificate File"),
	opts.SSLCertificateFile);
	dia.newf_str (MSG_U(F_SSLCERTKEYFILE,"Certificate Key File"),
	opts.SSLCertificateKeyFile);
	dia.newf_str (MSG_U(F_SSLCACERTPATH,"Certificate Path"),
	opts.SSLCACertificatePath);
	dia.newf_str (MSG_U(F_SSLCACERTFILE,"CA Certificate File"),
	opts.SSLCACertificateFile);
	dia.newf_str (MSG_U(F_SSLLOG,"Log"),opts.SSLLog);
	dia.newf_str (MSG_U(F_SSLOPTIONS,"Options"),opts.SSLOptions);
	dia.newf_num (MSG_U(F_VERIFYDEPTH,"Verify Depth"),opts.SSLVerifyDepth);
	dia.newf_num (MSG_U(F_SESSIONCACHETIMEOUT,"Session Cache Timeout"),
	opts.SSLSessionCacheTimeout);
	dia.newf_chk ("",opts.SSLEngine,MSG_U(I_SSLENGINE,"Engine"));
	loglevel =	dia.newf_combo (MSG_U(F_LOGLEVEL,"Log Level"),
	opts.SSLLogLevel);
	loglevelcomb(*loglevel);
	vercli = dia.newf_combo (MSG_U(F_SSLVERIFYCLIENT,"Verify Client"),
	opts.SSLVerifyClient);
	verifyclientcomb(*vercli);
	proto = dia.newf_combo (MSG_U(F_SSLPROTOCOL,"SSL Protocol"),
	opts.SSLProtocol);
	protocomb(*proto);
}

PUBLIC int HTTPD_CONFIG::editdefaults()
{
	int ret = -1;
	DIALOG dia;
	defdom.setdia (dia,true);
	dia.newf_title ("",MSG_U(T_TUNING,"Tuning"));
	dia.newf_num (MSG_U(F_LISTENPORT,"Listen on port"),port);
	dia.newf_str (MSG_U(F_PIDFILE,"Pid file"),pidfile);
	#if 0
		dia.newf_str (MSG_U(F_UID,"Execute as user"),user);
		dia.newf_str (MSG_U(F_GID,"Execute as group"),group);
	#endif
	dia.newf_num (MSG_R(F_TIMEOUT),timeout);
	dia.newf_chk ("",hostnamelookups,MSG_U(I_HOSTNAMELOOKUPS,"Host name lookups"));
	defdom.feats.setdia (dia);
	int nof = 0;
	while (1){
		MENU_STATUS code = dia.edit (
			MSG_U(T_APACHEDEF,"Apache defaults")
			,MSG_U(I_APACHEDEF,"You can configure the base setup and\n"
				"some defaults")
			,help_apache
			,nof);
		if (code == MENU_CANCEL || code == MENU_ESCAPE){
			break;
		}else if (code == MENU_ACCEPT){
			ret = 0;
			write();
			break;
		}
	}
	if (ret == -1) dia.restore();
	return ret;
}

int httpd_edit()
{
	int ret = 0;
	static const char *m_def = MSG_U(M_DEFAULT,"Defaults");
	static const char *m_domains = MSG_U(M_DOMAINS,"Virtual domains");
	static const char *m_subdirs = MSG_U(M_SUBDIRS,"Sub-directory specs");
	static const char *m_files = MSG_U(M_FILES,"Files specs");
	static const char *m_mod = MSG_U(M_MODS,"Modules");
	static const char *m_perf = MSG_U(M_PERF,"Performance");
	static const char *m_ssl = MSG_U(M_SSL,"mod_ssl configuration");

	static const char *menuopt[]={
		"",		m_def,
		"",		m_domains,
		"",		m_subdirs,
		"",		m_files,
		"",		m_mod,
		"", 	m_perf,
		"",		m_ssl,
		NULL,
	};
	DIALOG_MENU dia;
	dia.new_menuitems (menuopt);
	int choice=0;
	while (1){
		MENU_STATUS code = dia.editmenu (MSG_U(T_APACHE,"Apache administration")
			,MSG_U(I_APACHE,"This menu allows to configure the Apache web server")
			,help_apache
			,choice,0);
		if (code == MENU_QUIT || code == MENU_ESCAPE){
			break;
		}else{
			const char *key = menuopt[choice*2+1];
			HTTPD_CONFIG conf;
			if (key == m_def){
				conf.editdefaults();
			}else if (key == m_domains){
				conf.domains.edit(conf);
			}else if (key == m_subdirs){
				conf.dirs.edit(conf);
			}else if (key == m_ssl){
				conf.defssl.edit(conf);
			}else if (key == m_files){
				conf.dirs.f_edit(conf);
			}else if (key == m_mod){
				conf.modedit(conf);
			}else if (key == m_perf){
				conf.perfedit(conf);
			}
		}
	}	
	return ret;
}
