/* -*- mode: C++; tab-width: 4 -*- */
/* ================================================================================== */
/* Copyright (c) 1998-1999 3Com Corporation or its subsidiaries. All rights reserved. */
/* ================================================================================== */

#ifndef _UART_H_
#define _UART_H_


class TByteQueue;
class SessionFile;

class UART
{
	public:
		enum UART_Type
		{
			kUART_Dragonball,
			kUART_DragonballEZ
		};

		enum Parity
		{
			kNoParity,
			kOddParity,
			kEvenParity
		};

		struct State
		{
			State (UART_Type type) { UART_TYPE = type; }

			UART_Type	UART_TYPE;

			// UART control register bits
			// These are all values the user sets; we just look at them.

			/*  ->  */	unsigned int	UART_ENABLE:1;
			/*  ->  */	unsigned int	RX_ENABLE:1;
			/*  ->  */	unsigned int	TX_ENABLE:1;
			/*  ->  */	unsigned int	RX_CLK_CONT:1;
			/*  ->  */	unsigned int	PARITY_EN:1;
			/*  ->  */	unsigned int	ODD_EVEN:1;
			/*  ->  */	unsigned int	STOP_BITS:1;
			/*  ->  */	unsigned int	CHAR8_7:1;
			/*  ->  */	unsigned int	GPIO_DELTA_ENABLE:1;	// 68328 only
			/*  ->  */	unsigned int	OLD_ENABLE:1;			// 68EZ328 only
			/*  ->  */	unsigned int	CTS_DELTA_ENABLE:1;
			/*  ->  */	unsigned int	RX_FULL_ENABLE:1;
			/*  ->  */	unsigned int	RX_HALF_ENABLE:1;
			/*  ->  */	unsigned int	RX_RDY_ENABLE:1;
			/*  ->  */	unsigned int	TX_EMPTY_ENABLE:1;
			/*  ->  */	unsigned int	TX_HALF_ENABLE:1;
			/*  ->  */	unsigned int	TX_AVAIL_ENABLE:1;

			// Baud control register bits
			// These are all values the user sets; we just look at them.

			/*  ->  */	unsigned int	GPIO_DELTA:1;			// 68328 only
			/*  ->  */	unsigned int	GPIO:1;					// 68328 only
			/*  ->  */	unsigned int	GPIO_DIR:1;				// 68328 only
			/*  ->  */	unsigned int	GPIO_SRC:1;				// 68328 only
			/*  ->  */	unsigned int	UCLK_DIR:1;				// 68EZ328 only
			/*  ->  */	unsigned int	BAUD_SRC:1;
			/*  ->  */	unsigned int	DIVIDE;
			/*  ->  */	unsigned int	PRESCALER;

			// Receive register bits
			// These are all input bits; we set them, not the user.

			/*  <-  */	unsigned int	RX_FIFO_FULL:1;
			/*  <-  */	unsigned int	RX_FIFO_HALF:1;
			/*  <-  */	unsigned int	DATA_READY:1;
			/*  <-  */	unsigned int	OLD_DATA:1;				// 68EZ328 only
			/*  <-  */	unsigned int	OVRUN:1;
			/*  <-  */	unsigned int	FRAME_ERROR:1;
			/*  <-  */	unsigned int	BREAK:1;
			/*  <-  */	unsigned int	PARITY_ERROR:1;
			/*  <-  */	unsigned int	RX_DATA;

			// Transmitter register bits
			// The user sets TX_DATA, IGNORE_CTS, and SEND_BREAK.
			// We set the rest.

			/*  <-  */	unsigned int	TX_FIFO_EMPTY:1;
			/*  <-  */	unsigned int	TX_FIFO_HALF:1;
			/*  <-  */	unsigned int	TX_AVAIL:1;
			/*  ->  */	unsigned int	SEND_BREAK:1;
			/*  ->  */	unsigned int	IGNORE_CTS:1;
			/*  <-  */	unsigned int	BUSY:1;					// 68EZ328 only
			/*  <-  */	unsigned int	CTS_STATUS:1;
			/*  <-  */	unsigned int	CTS_DELTA:1;
			/*  ->  */	unsigned int	TX_DATA;

			// Misc register bits
			// These are all values the user sets; we just look at them.

			/*  ->  */	unsigned int	BAUD_TEST:1;			// 68EZ328 only
			/*  ->  */	unsigned int	CLK_SRC:1;
			/*  ->  */	unsigned int	FORCE_PERR:1;
			/*  ->  */	unsigned int	LOOP:1;
			/*  ->  */	unsigned int	BAUD_RESET:1;			// 68EZ328 only
			/*  ->  */	unsigned int	IR_TEST:1;				// 68EZ328 only
			/*  ->  */	unsigned int	RTS_CONT:1;
			/*  ->  */	unsigned int	RTS:1;
			/*  ->  */	unsigned int	IRDA_ENABLE:1;
			/*  ->  */	unsigned int	IRDA_LOOP:1;
			/*  ->  */	unsigned int	RX_POL:1;				// 68EZ328 only
			/*  ->  */	unsigned int	TX_POL:1;				// 68EZ328 only
		};

		static void				Initialize		(UART_Type);
		static void				Reset			(void);
		static void				Save			(SessionFile&);
		static void				Load			(SessionFile&);
		static void				Dispose			(void);

		static void				StateChanged	(State&, Bool sendRxData);
		static void				UpdateState		(State&, Bool refreshRxData);

		static Parity			GetLastParity			(void);
		static int				GetLastStopBits			(void);
		static int				GetLastDataBits			(void);
		static uae_u32			GetLastBaud				(void);
		static Bool				GetLastHwHandshaking	(void);

		static TByteQueue&		GetRxQueue		(void);
		static TByteQueue&		GetTxQueue		(void);
};

#endif /* _UART_H_ */
