/* -*- mode: C++; tab-width: 4 -*- */
/* ================================================================================== */
/* Copyright (c) 1998-1999 3Com Corporation or its subsidiaries. All rights reserved. */
/* ================================================================================== */

#ifndef _BANK_SED1375_H_
#define _BANK_SED1375_H_

#include "EmulatorTypes.h"			// RGBType

class SessionFile;

class SED1375Bank
{
	public:
		static void				Initialize		(void);
		static void				Reset			(void);
		static void				Save			(SessionFile&);
		static void				Load			(SessionFile&);
		static void				Dispose			(void);

		static void				InstallHandlers	(void);

		static uae_u32			GetLong			(uaecptr iAddress);
		static uae_u32			GetWord			(uaecptr iAddress);
		static uae_u32			GetByte			(uaecptr iAddress);
		static void				SetLong			(uaecptr iAddress, uae_u32 iLongValue);
		static void				SetWord			(uaecptr iAddress, uae_u32 iWordValue);
		static void				SetByte			(uaecptr iAddress, uae_u32 iByteValue);
		static int				ValidAddress	(uaecptr iAddress, uae_u32 iSize);
		static uae_u8*			GetRealAddress	(uaecptr iAddress);
		static uae_u8*			GetMetaAddress	(uaecptr iAddress);

		static int				GetLCDDepth		(void);
		static int				GetLCDRowBytes	(void);
		static int				GetLCDWidth		(void);
		static int				GetLCDHeight	(void);
		static uaecptr			GetLCDStartAddr	(void);
		static int				GetLCDPalette	(RGBType* scrPalette);
		static int				GetLCDOffset	(void);
		static Bool				LCDIsOn			(void);
		static Bool				BacklightIsOn	(void);

	private:
		static void				InvalidAccess	(uaecptr iAddress, long size, Bool forRead);
		static void				PreventedAccess	(uaecptr iAddress, long size, Bool forRead);

		friend class SED1375Reg;	// Calls SED1375Bank::InvalidAccess
};

#endif /* _BANK_SED1375_H_ */
  
