/*
 * Decompiled with CFR 0.152.
 */
package com.kvisco.xsl.functions;

import com.kvisco.util.List;
import com.kvisco.xsl.Expr;
import com.kvisco.xsl.ExprResult;
import com.kvisco.xsl.InvalidExprException;
import com.kvisco.xsl.ProcessorState;
import com.kvisco.xsl.StringExpr;
import com.kvisco.xsl.StringResult;
import com.kvisco.xsl.functions.FunctionCall;
import org.w3c.dom.Node;

public class Substring
extends FunctionCall {
    public Substring() {
        super("substring");
    }

    public ExprResult evaluate(Node node, ProcessorState processorState) throws InvalidExprException {
        List list = this.getParameterList();
        int n = list.size();
        if (n < 2 || n > 3) {
            throw new InvalidExprException("invalid number of parameters for function: " + this);
        }
        ExprResult exprResult = ((Expr)list.get(0)).evaluate(node, processorState);
        String string = StringExpr.toStringResult(exprResult).toString();
        int n2 = 1;
        exprResult = ((Expr)list.get(1)).evaluate(node, processorState);
        double d = exprResult.numberValue();
        if (Double.isNaN(d) || Double.isInfinite(d)) {
            return new StringResult("");
        }
        n2 = (int)Math.round(d);
        int n3 = string.length();
        if (n == 3) {
            exprResult = ((Expr)list.get(2)).evaluate(node, processorState);
            d = exprResult.numberValue();
            if (Double.isNaN(d)) {
                return new StringResult("");
            }
            if (Double.isInfinite(d)) {
                return new StringResult(string);
            }
            n3 = (int)Math.round(d);
        }
        int n4 = n2 + n3 - 1;
        n2 = n2 > 0 ? --n2 : 0;
        return new StringResult(string.substring(n2, n4));
    }
}

