/*
 * Decompiled with CFR 0.152.
 */
package com.kvisco.xsl.functions;

import com.kvisco.util.List;
import com.kvisco.xsl.Expr;
import com.kvisco.xsl.ExprResult;
import com.kvisco.xsl.InvalidExprException;
import com.kvisco.xsl.NumberResult;
import com.kvisco.xsl.ProcessorState;
import com.kvisco.xsl.StringExpr;
import com.kvisco.xsl.XSLObject;
import com.kvisco.xsl.functions.FunctionCall;
import org.w3c.dom.Node;

public class StringLength
extends FunctionCall {
    public StringLength() {
        super("string-length");
    }

    public ExprResult evaluate(Node node, ProcessorState processorState) throws InvalidExprException {
        List list = this.getParameterList();
        int n = list.size();
        if (n > 1) {
            throw new InvalidExprException("invalid number of parameters for function: " + this);
        }
        String string = null;
        if (n == 1) {
            Expr expr = (Expr)list.get(0);
            ExprResult exprResult = expr.evaluate(node, processorState);
            string = StringExpr.toStringResult(exprResult).toString();
        } else {
            string = XSLObject.getNodeValue(node);
        }
        return new NumberResult(string.length());
    }
}

