/*
 * Decompiled with CFR 0.152.
 */
package com.kvisco.xsl;

import com.kvisco.util.List;
import com.kvisco.util.Tokenizer;
import com.kvisco.xsl.AttributeSet;
import com.kvisco.xsl.Id;
import com.kvisco.xsl.Output;
import com.kvisco.xsl.TemplateRule;
import com.kvisco.xsl.Variable;
import com.kvisco.xsl.XSLException;
import com.kvisco.xsl.XSLImport;
import com.kvisco.xsl.XSLObject;
import com.kvisco.xsl.XSLScript;
import java.util.Enumeration;
import java.util.Hashtable;
import org.w3c.dom.ProcessingInstruction;

public class XSLStylesheet
extends XSLObject {
    public static final String XSL_NAMESPACE = "http://www.w3.org/XSL/Transform/";
    public static final String XMLNS_DECL = "xmlns:";
    public static final String XMLNS_ATTR = "xmlns";
    public static final String QUOTE = "quote:";
    protected static final String DOCTYPE_PI = "xsl:result-dtd";
    private static final String HTTP_PROTOCOL = "http:";
    private static final String FILE_PROTOCOL = "file:";
    private Hashtable attributeSets = new Hashtable();
    private Hashtable variables = new Hashtable();
    private String documentBase = "";
    private Hashtable namedTemplates = null;
    private String href = null;
    private Hashtable ids = null;
    private List imports = null;
    private List whitespaceElements = null;
    private List templates = null;
    private List gScripts = new List();
    private StringBuffer error = null;
    private String resultDocType = null;
    private String xslNSPrefix = "xsl";
    private Hashtable namespaces = null;
    private Hashtable quotedns = null;
    private boolean allowImports = true;
    private Hashtable avtMap = null;
    private boolean preserveSpaceByDefault = true;
    Output output = null;

    public XSLStylesheet() {
        super(null, (short)32);
        this.ids = new Hashtable();
        this.imports = new List();
        this.namedTemplates = new Hashtable();
        this.namespaces = new Hashtable();
        this.whitespaceElements = new List();
        this.quotedns = new Hashtable();
        this.templates = new List();
        this.output = new Output(this);
        super.appendAction(this.output);
        this.ids.put("id", "*");
    }

    public void addAttributeSet(AttributeSet attributeSet) {
        String string = attributeSet.getName();
        AttributeSet attributeSet2 = (AttributeSet)this.attributeSets.get(string);
        this.attributeSets.put(string, attributeSet);
    }

    public void addId(Id id) {
        String string = id.getIdAttribute();
        String string2 = id.getElementType();
        this.addId(string, string2);
    }

    public void addId(String string) {
        this.addId(string, "*");
    }

    public void addId(String string, String string2) {
        if (string2 == null) {
            string2 = "*";
        }
        if (!this.ids.contains(string)) {
            this.ids.put(string, string2);
            this.allowImports = false;
        }
    }

    public boolean addPI(ProcessingInstruction processingInstruction) {
        String string = processingInstruction.getTarget();
        if (DOCTYPE_PI.equals(string)) {
            this.resultDocType = processingInstruction.getData();
            return true;
        }
        return false;
    }

    public void addScript(XSLScript xSLScript) {
        this.gScripts.add(xSLScript);
        this.allowImports = false;
    }

    public void addTemplate(TemplateRule templateRule) throws XSLException {
        String string = templateRule.getAttribute("name");
        if (string != null) {
            if (this.namedTemplates.get(string) != null) {
                throw new XSLException("Duplicate template name found: " + string);
            }
            this.namedTemplates.put(string, templateRule);
        }
        this.templates.add(templateRule);
        this.allowImports = false;
    }

    public void addVariable(Variable variable) throws XSLException {
        String string = variable.getName();
        if (string == null || string.length() == 0) {
            throw new XSLException("missing name for variable.");
        }
        if (this.variables.contains(string)) {
            this.error = new StringBuffer("multiple variable declarations with the same name: ");
            this.error.append(string);
            throw new XSLException(this.error.toString());
        }
        this.allowImports = false;
        this.variables.put(string, variable);
    }

    public boolean appendAction(XSLObject xSLObject) {
        if (xSLObject == null) {
            return false;
        }
        try {
            switch (xSLObject.getType()) {
                case 25: {
                    String string = null;
                    Output output = (Output)xSLObject;
                    if (output.getAttribute("indent") != null) {
                        this.output.setIndent(output.getIndent());
                    }
                    if ((string = output.getMethod()) != null) {
                        this.output.setMethod(output.getMethod());
                    }
                    if ((string = output.getDoctypePublicId()) != null) {
                        this.output.setDoctypePublicId(string);
                    }
                    if ((string = output.getDoctypeSystemId()) != null) {
                        this.output.setDoctypeSystemId(string);
                    }
                    if ((string = output.getVersion()) == null) break;
                    this.output.setVersion(string);
                    break;
                }
                case 33: {
                    this.addTemplate((TemplateRule)xSLObject);
                    break;
                }
                case 4: {
                    this.addAttributeSet((AttributeSet)xSLObject);
                    break;
                }
                case 37: {
                    this.addVariable((Variable)xSLObject);
                    break;
                }
                case 15: {
                    this.addId((Id)xSLObject);
                    break;
                }
                case 40: {
                    this.addScript((XSLScript)xSLObject);
                    break;
                }
                case 17: {
                    this.importFrom((XSLImport)xSLObject);
                    break;
                }
                case 29: {
                    this.preserveSpace(xSLObject.getAttribute("elements"));
                    break;
                }
                case 31: {
                    this.stripSpace(xSLObject.getAttribute("elements"));
                    break;
                }
                default: {
                    return false;
                }
            }
            super.appendAction(xSLObject);
        }
        catch (XSLException xSLException) {
            return false;
        }
        return true;
    }

    private void copyFromXSLStylesheet(XSLStylesheet xSLStylesheet) {
        this.copyHashtableInto(this.attributeSets, xSLStylesheet.getAttributeSets(), true);
        this.copyHashtableInto(this.variables, xSLStylesheet.getVariables(), true);
        this.copyHashtableInto(this.ids, xSLStylesheet.getIds(), true);
        this.copyHashtableInto(this.namespaces, xSLStylesheet.getNamespaces(), false);
        this.copyHashtableInto(this.quotedns, xSLStylesheet.getQuotedNamespaces(), false);
        this.copyListInto(this.gScripts, xSLStylesheet.getScripts());
    }

    private void copyHashtableInto(Hashtable hashtable, Hashtable hashtable2, boolean bl) {
        if (hashtable == null || hashtable2 == null) {
            return;
        }
        Enumeration enumeration = hashtable2.keys();
        while (enumeration.hasMoreElements()) {
            Object k = enumeration.nextElement();
            if (!bl && hashtable.get(k) != null) continue;
            hashtable.put(k, hashtable2.get(k));
        }
    }

    private void copyListInto(List list, List list2) {
        if (list == null || list2 == null) {
            return;
        }
        int n = 0;
        while (n < list2.size()) {
            list.add(list2.get(n));
            ++n;
        }
    }

    private void copyListInto(List list, Object[] objectArray) {
        if (list == null || objectArray == null) {
            return;
        }
        int n = 0;
        while (n < objectArray.length) {
            list.add(objectArray[n]);
            ++n;
        }
    }

    public int countTemplates() {
        int n = this.templates.size();
        int n2 = 0;
        while (n2 < this.imports.size()) {
            n += ((XSLStylesheet)this.imports.get(n2)).countTemplates();
            ++n2;
        }
        return n;
    }

    public AttributeSet getAttributeSet(String string) {
        return (AttributeSet)this.attributeSets.get(string);
    }

    public Hashtable getAttributeSets() {
        return (Hashtable)this.attributeSets.clone();
    }

    public String getDocumentBase() {
        return this.documentBase;
    }

    public String getHref() {
        return this.href;
    }

    public Hashtable getIds() {
        return this.ids;
    }

    public List getLocalTemplates() {
        return (List)this.templates.clone();
    }

    public TemplateRule getNamedTemplate(String string) {
        if (string == null) {
            return null;
        }
        TemplateRule templateRule = (TemplateRule)this.namedTemplates.get(string);
        if (templateRule == null) {
            int n = this.imports.size() - 1;
            while (n >= 0) {
                XSLStylesheet xSLStylesheet = (XSLStylesheet)this.imports.get(n);
                templateRule = xSLStylesheet.getNamedTemplate(string);
                if (templateRule != null) break;
                --n;
            }
        }
        return templateRule;
    }

    public Enumeration getNamedTemplates() {
        return this.namedTemplates.elements();
    }

    protected Hashtable getNamespaces() {
        return this.namespaces;
    }

    public Output getOutput() {
        return this.output;
    }

    public String getQuotedNamespace(String string) {
        if (string == null) {
            return null;
        }
        String string2 = (String)this.quotedns.get(string);
        if (string2 != null) {
            Enumeration enumeration = this.namespaces.keys();
            while (enumeration.hasMoreElements()) {
                String string3 = (String)enumeration.nextElement();
                if (!string2.equals(this.namespaces.get(string3))) continue;
                return string3;
            }
        }
        return string;
    }

    protected Hashtable getQuotedNamespaces() {
        return this.quotedns;
    }

    public String getResultDocType() {
        return this.resultDocType;
    }

    public String getResultNamespace() {
        return this.getAttribute("result-ns");
    }

    public List getScripts() {
        return (List)this.gScripts.clone();
    }

    public TemplateRule[] getTemplates() {
        List list = new List(this.countTemplates());
        int n = 0;
        while (n < this.imports.size()) {
            this.copyListInto(list, ((XSLStylesheet)this.imports.get(n)).getTemplates());
            ++n;
        }
        this.copyListInto(list, this.templates);
        return (TemplateRule[])list.toArray(new TemplateRule[list.size()]);
    }

    public Variable getVariableDecl(String string) {
        return (Variable)this.variables.get(string);
    }

    public Hashtable getVariables() {
        return (Hashtable)this.variables.clone();
    }

    public String getXSLNSPrefix() {
        return this.xslNSPrefix;
    }

    public void importFrom(XSLImport xSLImport) throws XSLException {
        if (xSLImport == null) {
            return;
        }
        XSLStylesheet xSLStylesheet = xSLImport.getStylesheet();
        String string = xSLStylesheet.getHref();
        if (string != null) {
            if (this.isAllowableImport(string)) {
                this.importWithoutVerify(xSLImport);
            } else {
                throw new XSLException("Stylesheet " + string + " has already been directly or indirectly imported.");
            }
        }
    }

    public void importFrom(XSLStylesheet xSLStylesheet) throws XSLException {
        this.importFrom(new XSLImport(this, xSLStylesheet));
    }

    protected void importWithoutVerify(XSLImport xSLImport) throws XSLException {
        if (xSLImport == null) {
            return;
        }
        if (!this.allowImports) {
            throw new XSLException("Imports must occur before all other elements of the stylesheet.");
        }
        XSLStylesheet xSLStylesheet = xSLImport.getStylesheet();
        if (xSLStylesheet == null) {
            return;
        }
        this.imports.add(xSLStylesheet);
        this.copyFromXSLStylesheet(xSLStylesheet);
    }

    protected void importWithoutVerify(XSLStylesheet xSLStylesheet) throws XSLException {
        this.importWithoutVerify(new XSLImport(this, xSLStylesheet));
    }

    public void includeFrom(XSLStylesheet xSLStylesheet) throws XSLException {
        if (xSLStylesheet == null) {
            return;
        }
        String string = xSLStylesheet.getHref();
        if (string != null) {
            if (this.isAllowableImport(string)) {
                this.includeWithoutVerify(xSLStylesheet);
            } else {
                throw new XSLException("Stylesheet " + string + " has already been directly or indirectly included.");
            }
        }
    }

    protected void includeWithoutVerify(XSLStylesheet xSLStylesheet) throws XSLException {
        if (xSLStylesheet == null) {
            return;
        }
        this.allowImports = false;
        this.copyFromXSLStylesheet(xSLStylesheet);
        TemplateRule[] templateRuleArray = xSLStylesheet.getTemplates();
        int n = 0;
        while (n < templateRuleArray.length) {
            this.addTemplate(templateRuleArray[n]);
            ++n;
        }
    }

    public boolean isAllowableImport(String string) {
        if (this.href != null && string.equals(this.href)) {
            return false;
        }
        int n = 0;
        while (n < this.imports.size()) {
            XSLStylesheet xSLStylesheet = (XSLStylesheet)this.imports.get(n);
            if (!xSLStylesheet.isAllowableImport(string)) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public boolean isStripSpaceAllowed(String string) {
        if (this.preserveSpaceByDefault) {
            return this.whitespaceElements.contains(string);
        }
        return this.whitespaceElements.contains(string) ^ true;
    }

    /*
     * Unable to fully structure code
     */
    public void preserveSpace(String var1_1) {
        block3: {
            if (var1_1 == null) {
                return;
            }
            var2_2 = new Tokenizer(var1_1);
            if (this.preserveSpaceByDefault) ** GOTO lbl12
            while (var2_2.hasMoreTokens()) {
                this.whitespaceElements.add(var2_2.nextToken());
            }
            break block3;
lbl-1000:
            // 1 sources

            {
                this.whitespaceElements.remove(var2_2.nextToken());
lbl12:
                // 2 sources

                ** while (var2_2.hasMoreTokens())
            }
        }
    }

    public void setAttribute(String string, String string2) throws XSLException {
        if (string.indexOf(XMLNS_DECL) == 0) {
            String string3 = string.substring(XMLNS_DECL.length());
            this.namespaces.put(string3, string2);
            if (string2.indexOf(QUOTE) == 0) {
                this.quotedns.put(string3, string2.substring(QUOTE.length()));
            }
            if (string2.startsWith(XSL_NAMESPACE)) {
                this.xslNSPrefix = string3;
            }
        } else if ((string = string.intern()) == "default-space") {
            this.preserveSpaceByDefault = "preserve".equals(string2);
        } else if (string == "indent-result") {
            this.output.setIndent("yes".equals(string2));
        } else if (string == "result-ns") {
            this.output.setMethod(string2);
        }
        super.setAttribute(string, string2);
    }

    public void setDocumentBase(String string) {
        this.documentBase = string;
    }

    public void setHref(String string) {
        this.href = string;
    }

    /*
     * Unable to fully structure code
     */
    public void stripSpace(String var1_1) {
        block3: {
            if (var1_1 == null) {
                return;
            }
            var2_2 = new Tokenizer(var1_1);
            if (!this.preserveSpaceByDefault) ** GOTO lbl12
            while (var2_2.hasMoreTokens()) {
                this.whitespaceElements.add(var2_2.nextToken());
            }
            break block3;
lbl-1000:
            // 1 sources

            {
                this.whitespaceElements.remove(var2_2.nextToken());
lbl12:
                // 2 sources

                ** while (var2_2.hasMoreTokens())
            }
        }
    }
}

