/*
 * Decompiled with CFR 0.152.
 */
package org.openxml.source.holders;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import org.openxml.DOMFactory;
import org.openxml.dom.DocumentImpl;
import org.openxml.io.Parser;
import org.openxml.parser.XMLParser;
import org.openxml.source.Holder;
import org.w3c.dom.Document;

class HolderImpl
extends Holder {
    protected String _uri;
    protected String _encoding;
    protected Document _document;
    protected Class _docClass;
    protected IOException _lastException;

    protected HolderImpl(String string, String string2, Class clazz) throws IOException {
        if (string == null) {
            throw new NullPointerException("Argument 'uri' is null.");
        }
        this._uri = string;
        this._encoding = string2;
        this._docClass = clazz;
    }

    public boolean canCache() {
        return false;
    }

    public String getEncoding() {
        return this._encoding == null ? "UTF8" : this._encoding;
    }

    public IOException getLastException() {
        return this._lastException;
    }

    public Document getReadOnly() {
        if (this._document == null) {
            this._document = this.parseSource();
        }
        if (this.canCache() && this._document instanceof DocumentImpl) {
            ((DocumentImpl)this._document).makeReadOnly();
        }
        return this._document;
    }

    public Reader getReader() throws IOException {
        return this.getReader(new URL(this._uri).openStream());
    }

    protected Reader getReader(InputStream inputStream) throws IOException {
        return new BufferedReader(new InputStreamReader(inputStream));
    }

    public String getURI() {
        return this._uri;
    }

    public boolean hasModified() {
        return true;
    }

    public Document newInstance() {
        Document document = this.getReadOnly();
        if (this.canCache() && document != null) {
            document = (Document)document.cloneNode(true);
        }
        return document;
    }

    protected Document parseSource() {
        Parser parser;
        try {
            parser = DOMFactory.createParser(new BufferedReader(this.getReader()), this.getURI(), this._docClass);
        }
        catch (IOException iOException) {
            this._lastException = iOException;
            return null;
        }
        try {
            this._document = this._docClass != null && parser instanceof XMLParser ? ((XMLParser)parser).parseDocument(null, this._docClass) : parser.parseDocument();
        }
        catch (IOException iOException) {}
        this._lastException = parser.getLastException();
        return this._document;
    }
}

