/*
 * Decompiled with CFR 0.152.
 */
package org.openxml.dom.html;

import org.openxml.dom.html.HTMLDocumentImpl;
import org.openxml.dom.html.HTMLElementImpl;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.w3c.dom.html.HTMLElement;
import org.w3c.dom.html.HTMLOptionElement;
import org.w3c.dom.html.HTMLSelectElement;

public final class HTMLOptionElementImpl
extends HTMLElementImpl
implements HTMLOptionElement {
    public HTMLOptionElementImpl(HTMLDocumentImpl hTMLDocumentImpl, String string) {
        super(hTMLDocumentImpl, "OPTION");
    }

    public boolean getDefaultSelected() {
        return this.getAttribute("default-selected") != null;
    }

    public boolean getDisabled() {
        return this.getAttribute("disabled") != null;
    }

    public int getIndex() {
        Node node = this.getParentNode();
        while (node != null && !(node instanceof HTMLSelectElement)) {
            node = node.getParentNode();
        }
        if (node != null) {
            NodeList nodeList = ((HTMLElement)node).getElementsByTagName("OPTION");
            int n = 0;
            while (n < nodeList.getLength()) {
                if (nodeList.item(n) == this) {
                    return n;
                }
                ++n;
            }
        }
        return -1;
    }

    public String getLabel() {
        return this.capitalize(this.getAttribute("label"));
    }

    public boolean getSelected() {
        return this.getAttribute("selected") != null;
    }

    public String getText() {
        Node node = this.getFirstChild();
        String string = "";
        while (node != null) {
            if (node instanceof Text) {
                string = String.valueOf(string) + ((Text)node).getData();
            }
            node = node.getNextSibling();
        }
        return string;
    }

    public String getValue() {
        return this.getAttribute("value");
    }

    public void setDefaultSelected(boolean bl) {
        this.setAttribute("default-selected", bl ? "" : null);
    }

    public void setDisabled(boolean bl) {
        this.setAttribute("disabled", bl ? "" : null);
    }

    public void setIndex(int n) {
        NodeList nodeList;
        Node node = this.getParentNode();
        while (node != null && !(node instanceof HTMLSelectElement)) {
            node = node.getParentNode();
        }
        if (node != null && (nodeList = ((HTMLElement)node).getElementsByTagName("OPTION")).item(n) != this) {
            this.getParentNode().removeChild(this);
            Node node2 = nodeList.item(n);
            node2.getParentNode().insertBefore(this, node2);
        }
    }

    public void setLabel(String string) {
        this.setAttribute("label", string);
    }

    public void setSelected(boolean bl) {
        this.setAttribute("selected", bl ? "" : null);
    }

    public void setText(String string) {
        Node node = this.getFirstChild();
        while (node != null) {
            Node node2 = node.getNextSibling();
            this.removeChild(node);
            node = node2;
        }
        this.insertBefore(this.getOwnerDocument().createTextNode(string), this.getFirstChild());
    }

    public void setValue(String string) {
        this.setAttribute("value", string);
    }
}

