/*
 *  Sarien AGI :: Copyright (C) 1999 Dark Fiber
 *
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <limits.h>

#include "sarien.h"
#include "agi.h"
#include "gfx.h"
#include "keyboard.h"
#include "font.h"
#include "rand.h"
#include "objects.h"
#include "picture.h"
#include "view.h"
#include "logic.h"
#include "menu.h"
#include "console.h"


UINT8		*null_msg=(UINT8*)"";
UINT8		*gname=NULL;		/* lead in id (eg, goldrush GR */
UINT8		*gdir=NULL;		/* game dir (for v3 games, eg GR<dir> */
UINT8		*gid=NULL;		/* game id */
UINT8		path[1024];		/* holds expanded paths for files */
UINT8		horizon;		/* horizon marker */
AGI_LOADER	*loader;		/* loader */
AGI_DIR		dir_logic[MAX_DIRS];	/* directory entries for logics */
AGI_DIR		dir_pic[MAX_DIRS];	/* directory entries for pictures */
AGI_DIR		dir_view[MAX_DIRS];	/* directory entries for views */
AGI_DIR		dir_sound[MAX_DIRS];	/* directory entries for sounds */
UINT8		flags[MAX_FLAGS/CHAR_BIT];	/* 256 bit flags */
UINT8		vars[MAX_VARS];		/* 256 byte variables */
UINT16		ego_in_new_room;	/* new room flag */
UINT8		control_mode;		/* who's in control */
UINT8		quit_prog_now;		/* quit now */
UINT8		status_line;		/* status line on/off */
UINT8		line_status;		/* line num to put status on */
UINT8		line_user_input;	/* line to put user input on */
UINT8		line_min_print;		/* num lines to print on */
UINT8		allow_kyb_input;	/* allow keyboard input */
UINT8		clock_enabled;		/* clock is on/off */
//UINT8		timed_message_box;	/* timed message box */
UINT16		message_box_key;	/* message box keypress */
UINT32		game_flags;		/* game flags!! (important) */

volatile UINT32	msg_box_secs2;		/* message box timeout in sec/2 */


UINT16 agi_init(void)
{
	UINT16 ec;
	UINT16 i;

	gid=NULL;			/* clean out GAME ID */

	/* set the font */
	if(optAGDS==__TRUE)
		font=(UINT8*)font_russian;
	else
		font=(UINT8*)font_english;

	/* reset all flags to false */
	for(i=0; i<MAX_FLAGS; i++)
		setflag(i, __FALSE);

	/* reset all variables to 0 */
	for(i=0; i<MAX_VARS; i++)
		setvar(i, 0);

	/* clear all logics */
	memset(&logics, 0x0, MAX_DIRS * sizeof(AGI_LOGIC));

	/* clear all pictures */
	memset(&pictures, 0x0, MAX_DIRS * sizeof(AGI_PICTURE));

	/* clear all views */
	memset(&views, 0x0, MAX_DIRS * sizeof(AGI_VIEW));

	/* clear all evets */
	memset(&events, 0x0, MAX_DIRS * sizeof(AGI_EVENT));

	/* clear words */
	init_words();

	/* init the view table */
	init_view_table();

	/* init random seed */
	set_rnd_seed();

	/* init menus */
	init_menus();

	/* clear string buffer */
	for(i=0; i<MAX_WORDS1; i++)
		strings[i][0]=0x0;

	/* setup emulation */

	report ("Emulating Sierra AGI v");
	switch(loader->int_version>>12)
	{
	case 2:
		report ("%x.%03x\n",
			(SINT)(loader->int_version>>12)&0xF,
			(SINT)(loader->int_version)&0xFFF);
		break;
	case 3:
		report ("%x.002.%03x\n",
			(SINT)(loader->int_version>>12)&0xF,
			(SINT)(loader->int_version)&0xFFF);
		break;
	}

	if(optAmiga==__TRUE)
		game_flags|=ID_AMIGA;
	if(optAGDS==__TRUE)
		game_flags|=ID_AGDS;
	if((game_flags&ID_AMIGA)==ID_AMIGA)
		printf ("Amiga padded game detected\n");
	if((game_flags&ID_AGDS)==ID_AGDS)
		printf ("AGDS mode enabled\n");

	screen_mode=GFX_MODE;
	/*allow_kyb_input=__FALSE;*/
	txt_fg=0xF;
	txt_bg=0x0;

	ec=loader->init();			/* load vol files, etc */

	if(ec == err_OK)
		ec=load_objects((UINT8*)OBJECTS);

	/* CM: ec= commented out, demogs has no words.tok */
	if(ec == err_OK)
		/*ec =*/ load_words((UINT8*)WORDS);

	/* FIXME: load IIgs instruments and samples */
	/* load_instruments("kq.sys16"); */

	/* Load logic 0 into memory, set cache flag for logic 0 */
	if(ec == err_OK) {
		ec=loader->load_resource(rLOGIC, 0);
		dir_logic[0].flags|=RES_CACHED;	/* keep this one cached */
	}

	/* if cached, enable caching options */
	if(optCache==__TRUE)
	{
		for(i=0; i<MAX_DIRS; i++)
		{
			dir_logic[i].flags|=RES_CACHED;
			dir_pic[i].flags|=RES_CACHED;
			dir_view[i].flags|=RES_CACHED;
			dir_sound[i].flags|=RES_CACHED;
		}
	}

	/* if forced, load all cacheable objects */
	if(optForce==__TRUE && ec==err_OK)
	{
		for(i=0; i<MAX_DIRS; i++)
		{
			printf("Force loading cached resource : Logic : %4i\r", i);
			fflush (stdout);
			loader->load_resource (rLOGIC, i);
		}
		printf("\n");

		for(i=0; i<MAX_DIRS; i++)
		{
			printf("Force loading cached resource : Picture : %4i\r", i);
			fflush(stdout);
			loader->load_resource(rPICTURE, i);
		}
		printf("\n");

		for(i=0; i<MAX_DIRS; i++)
		{
			printf("Force loading cached resource : View : %4i\r", i);
			fflush(stdout);
			loader->load_resource(rVIEW, i);
		}
		printf("\n");
	}

	return ec;
}

UINT16 agi_deinit(void)
{
	UINT16 ec;

	/* clean out video memory */
	reset_graphics();

	/* remove all words from memory */
	clean_input();

	/* release game ID if one is present */
	if(gid!=NULL)
	{
		free(gid);
		gid=NULL;
	}

	/* release game name if present */
	/* ack. v3 needs this no restart.. */
	/*
	if(gname!=NULL)
	{
		free(gname);
		gname=NULL;
	}
	*/

	/* unload the menus */
	deinit_menus();

	/* unload resources in memory */
	unload_resources();

	ec=loader->deinit();

	unload_objects();
	unload_words();

	ego_in_new_room=0;
	control_mode=0;
	quit_prog_now=0;
	status_line=__FALSE;
	line_status=0;
	line_user_input=0;
	line_min_print=0;
	allow_kyb_input=0;
	clock_enabled=0;
	//timed_message_box=0;
	message_box_key=0;

	return ec;
}
