/* pixels.c */

/* This file is compiled several times with different bit-depths defined. */
/* See fb.c */

#undef pixel_t

#if (DEPTH==8)
  #define pixel_t unsigned char
#endif

#if (DEPTH==16)
  #define pixel_t unsigned short int
#endif

#if (DEPTH==32)
  #define pixel_t unsigned int
#endif

#undef pixmap
#define pixmap ((pixel_t *)fb)

#undef palette
#define palette ((pixel_t *)palette)


#if (DEPTH==8)
void drawimage8(int endclock)
#endif
#if (DEPTH==16)
void drawimage16(int endclock)
#endif
#if (DEPTH==32)
void drawimage32(int endclock)
#endif
{
  static unsigned int lastclock=0;
  static unsigned int curhscroll=0;
  unsigned int curclock=lastclock;
  unsigned int baseaddr=((RAM[0x2000]&0x10)<<8); /* 0 or 0x1000 */
  unsigned int currentline=lastclock/341;
  unsigned int hposition=lastclock%341;
  unsigned int x;
  int s;
  int hflip,vflip,behind;
  int d1,d2;
  int spritebase=(RAM[0x2000]&0x08)<<9;/* 0x0 or 0x1000 */
  int spritesize=8<<((RAM[0x2000]&0x20)>>5); /* 8 or 16 */
  int spritetile;
  unsigned char linebuffer[256];
  unsigned char bgmask[256];
  static unsigned int tile;
  static int bit;
  static unsigned char byte1,byte2;
  static pixel_t curpal[4];
  static unsigned char tilecolor;
  static pixel_t *ptr;

  if(frameskip) { return; }

/* 113 2/3 cpu cycles per scanline */
/* = 341 ppu cycles per scanline */
/* = 81840 ppu cycles per frame (not counting vblank) */
/* = 89342 ppu cycles per frame (including vblank) */

  if(endclock>81840) return;
  if(curclock>81840) curclock=0;
  if(endclock<=curclock) return;
  if(curclock==0)
  {
    /* Begin new frame */
    vline=vscrollreg>>3;
    vscan=vscrollreg&7;
    vwrap=0;
    if(osmirror) scanpage=0x2000;
    else if(nomirror) scanpage=0x2000+((RAM[0x2000]&3)<<10);
    else if(hvmirror==0) scanpage=0x2000+((RAM[0x2000]&1)<<10); /* v-mirror, h-layout */
    else if(hvmirror==1) scanpage=0x2000+((RAM[0x2000]&2)<<9); /* h-mirror, v-layout */
    curpal[0]=palette[24];
    ptr=pixmap;
  }

  if(hposition>=85)
  {
    /* In scanline */
    x=hposition-85+curhscroll;
  }
  else
  {
    /* In hblank */
    curhscroll=hscrollreg;
    x=curhscroll;
    tile=VRAM[scanpage+((x&255)>>3)+(vline<<5)];
    byte1=VRAM[baseaddr+(tile<<4)+vscan]<<(x&7);
    byte2=VRAM[baseaddr+(tile<<4)+vscan+8]<<(x&7);
    bit=(~x)&7;
    curclock+=85-hposition;
    hposition=85;
    tilecolor=VRAM[scanpage+0x3C0+((x&255)>>5)+((vline&28)<<1)]>>((vline&2)<<1);
    if(x&16) tilecolor>>=2;
    curpal[1]=palette[3*(tilecolor&3)];
    curpal[2]=palette[3*(tilecolor&3)+1];
    curpal[3]=palette[3*(tilecolor&3)+2];
  }

  while(curclock<endclock)
  {
    
    while(hposition<341&&curclock<endclock)
    {
      if(RAM[0x2001]&8)
      {
        bit--;
        *(ptr++)=curpal[bgmask[hposition-85]=(((byte1&0x80)>>7)|((byte2&0x80)>>6))];
        byte1<<=1;byte2<<=1;
      }
      else
        *(ptr++)=*curpal; /* Blank screen / Background color */

      x++;hposition++;curclock++;
      if(x==256) if((!osmirror)&&(nomirror||!hvmirror)) scanpage^=0x400; /* bit 8 of x -> bit 10 of addr */
      if(bit<0)
      {
        tile=VRAM[scanpage+((x&255)>>3)+(vline<<5)];
        byte1=VRAM[baseaddr+(tile<<4)+vscan];
        byte2=VRAM[baseaddr+(tile<<4)+vscan+8];
        bit=7;
        if((x&0xf)==0)
        {
          if((x&0x1f)==0)
            tilecolor=VRAM[scanpage+0x3C0+((x&255)>>5)+((vline&28)<<1)]>>((vline&2)<<1);
          else
            tilecolor>>=2;
          curpal[1]=palette[3*(tilecolor&3)];
          curpal[2]=palette[3*(tilecolor&3)+1];
          curpal[3]=palette[3*(tilecolor&3)+2];
        }
      }
    }

    if(hposition==341)
    {
      if(RAM[0x2001]&16)
      {
        /* Draw sprites */
        memset(linebuffer,0,256); /* Clear buffer for this scanline */
        for(s=63;s>=0;s--)
        {
          if(spriteram[s*4]<currentline&&spriteram[s*4]<240&&spriteram[s*4+3]<249)
          {
            if(spriteram[s*4]+spritesize>=currentline)
            {
              spritetile=spriteram[s*4+1];
              if(spritesize==16) spritebase=(spritetile&1)<<12;
              behind=spriteram[s*4+2]&0x20;
              hflip=spriteram[s*4+2]&0x40;
              vflip=spriteram[s*4+2]&0x80;

              /* This finds the memory location of the tiles, taking into account
                 that vertically flipped sprites are in reverse order. */
              if(vflip)
              {
                if(spriteram[s<<2]>=((signed int)currentline)-8) /* 8x8 sprites and first half of 8x16 sprites */
                {
                  d1=VRAM[spritebase+((spritetile&(~(spritesize>>4)))<<4)+spritesize*2-8-currentline+spriteram[s*4]];
                  d2=VRAM[spritebase+((spritetile&(~(spritesize>>4)))<<4)+spritesize*2-currentline+spriteram[s*4]];
                }
                else /* Do second half of 8x16 sprites */
                {
                  d1=VRAM[spritebase+((spritetile&(~(spritesize>>4)))<<4)+spritesize*2-16-currentline+spriteram[s*4]];
                  d2=VRAM[spritebase+((spritetile&(~(spritesize>>4)))<<4)+spritesize*2-8-currentline+spriteram[s*4]];
                }
              }
              else
              {
                if(spriteram[s<<2]>=((signed int)currentline)-8) /* 8x8 sprites and first half of 8x16 sprites */
                {
                  d1=VRAM[spritebase+((spritetile&(~(spritesize>>4)))<<4)+currentline-1-spriteram[s*4]];
                  d2=VRAM[spritebase+((spritetile&(~(spritesize>>4)))<<4)+currentline+7-spriteram[s*4]];
                }
                else /* Do second half of 8x16 sprites */
                {
                  d1=VRAM[spritebase+((spritetile&(~(spritesize>>4)))<<4)+currentline+7-spriteram[s*4]];
                  d2=VRAM[spritebase+((spritetile&(~(spritesize>>4)))<<4)+currentline+15-spriteram[s*4]];
                }
              }
              for(x=7*(!hflip);x<8&&x>=0;x+=1-((!hflip)<<1))
              {
                if(d1&d2&1) linebuffer[spriteram[s*4+3]+x]=12+2+((spriteram[s*4+2]&3)*3);
                else if(d1&1) linebuffer[spriteram[s*4+3]+x]=12+((spriteram[s*4+2]&3)*3);
                else if(d2&1) linebuffer[spriteram[s*4+3]+x]=12+1+((spriteram[s*4+2]&3)*3);
                if(behind&&(d1|d2))
                  if(bgmask[spriteram[s*4+3]+x]) linebuffer[spriteram[s*4+3]+x]=0; /* Sprite hidden behind background */
                d1>>=1;d2>>=1;
              }
            }
          }
        }
        
        for(x=0;x<256;x++)
        {
          if(linebuffer[x]) ptr[spriteram[s*4+3]+x-256]=palette[linebuffer[x]];
        }
      }
        
      /* Next line */
      currentline++;
      curhscroll=hscrollreg;
      x=curhscroll;
      vscan++;
      if (vscan>=8)
      {
        vscan=0;vline++;
        vline&=31;
        if (vline==30) {vline=0;vwrap^=1;}
      }
      if(osmirror) scanpage=0x2000;
      else if(nomirror) scanpage=0x2000+(((RAM[0x2000]&3)<<10)^(vwrap<<11));
      else if(hvmirror==0) scanpage=0x2000+((RAM[0x2000]&1)<<10); /* v-mirror, h-layout */
      else if(hvmirror==1) scanpage=0x2000+(((RAM[0x2000]&2)<<9)^(vwrap<<10)); /* h-mirror, v-layout */
      tile=VRAM[scanpage+((x&255)>>3)+(vline<<5)];
      byte1=VRAM[baseaddr+(tile<<4)+vscan]<<(x&7);
      byte2=VRAM[baseaddr+(tile<<4)+vscan+8]<<(x&7);
      bit=(~x)&7;
      tilecolor=VRAM[scanpage+0x3C0+((x&255)>>5)+((vline&28)<<1)]>>((vline&2)<<1);
      if(x&16) tilecolor>>=2;
      curpal[1]=palette[3*(tilecolor&3)];
      curpal[2]=palette[3*(tilecolor&3)+1];
      curpal[3]=palette[3*(tilecolor&3)+2];
      hposition=85;
      curclock+=85;
    }
  }

  if((lastclock=endclock)>=81840) lastclock=0;

  /*for(x=0;x<1024;x++) if((x&255)<208)pixmap[x]=palette[((x&255)>>3)%26];*/ /* Display palette for debug */

}
