#include <string>
#include "CWGlob.h"

////////////////////////////////////////////////////////////////////////
// public
////////////////////////////////////////////////////////////////////////

CWGlob::CWGlob(const string& pattern, bool fMark, bool fSort)
  : _pattern(pattern)
{
  int flags = 0;
  if( fMark )
    flags |= GLOB_MARK;
  if( fSort )
    flags |= GLOB_NOSORT;

  switch( glob(_pattern.c_str(), flags, &GlobErr, &_results) )
    {
    case GLOB_NOSPACE:
      throw GLOB_NOSPACE;
      break;
      
    case GLOB_ABORTED:
      throw GLOB_ABORTED;
      break;
      
    default:
      break;
    };

  for(unsigned i = 0 ; i < _results.gl_pathc ; i++ )
    _path.push_back(_results.gl_pathv[i]);
}

CWGlob::~CWGlob()
{
  globfree(&_results);
}



////////////////////////////////////////////////////////////////////////
// protected
////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////
// private
////////////////////////////////////////////////////////////////////////

int CWGlob::GlobErr(const char * epath, int eerrno)
{
  return 0;  // continue globing.
}
