/*
 * FramedArea - frame around component
 *
 * created: apesen, 19961101
 *
 * changed: apesen, 19961114
 *
 * $Id: FramedArea.java,v 1.1 1997/01/15 13:42:55 mpichler Exp $
 */


package iicm.widgets;

import java.awt.*;


/* class FramedArea */
public class FramedArea extends Panel 
{
  public FramedArea()
  { 
    super();
    setLayout(new GridLayout(1,0));
  }

  public FramedArea(Component cmp)
  { 
    super();
    setLayout(new GridLayout(1,0));
    add(cmp);
  }

  //Ensure that no Component is placed on top of the frame.
  //The inset values were determined by trail and error.
  public Insets insets() 
  { 
    return new Insets(4,4,5,5);
  }

//  Draw the frame at this Panel's edges.
  public void paint(Graphics g) 
  {
    Dimension d = size();
    Color bg = getBackground();
         
    g.setColor(bg);
    g.draw3DRect(0, 0, d.width - 1, d.height - 1, true);
    g.draw3DRect(3, 3, d.width - 7, d.height - 7, false);
  }
} // FramedArea
