/*
 * Decompiled with CFR 0.152.
 */
package netscape.ldap.client.opers;

import java.io.IOException;
import netscape.ldap.ber.stream.BERElement;
import netscape.ldap.ber.stream.BEROctetString;
import netscape.ldap.ber.stream.BERSequence;
import netscape.ldap.ber.stream.BERTag;
import netscape.ldap.client.opers.JDAPProtocolOp;

public class JDAPSearchResultReference
implements JDAPProtocolOp {
    protected String[] m_urls;
    protected BERElement m_element;

    public JDAPSearchResultReference(BERElement bERElement) throws IOException {
        this.m_element = bERElement;
        BERSequence bERSequence = (BERSequence)((BERTag)bERElement).getValue();
        if (bERSequence.size() < 0) {
            return;
        }
        this.m_urls = new String[bERSequence.size()];
        int n = 0;
        while (n < bERSequence.size()) {
            BEROctetString bEROctetString = (BEROctetString)bERSequence.elementAt(n);
            this.m_urls[n] = new String(bEROctetString.getValue(), "UTF8");
            ++n;
        }
    }

    public int getType() {
        return 19;
    }

    public BERElement getBERElement() {
        return this.m_element;
    }

    public String[] getUrls() {
        return this.m_urls;
    }

    public String toString() {
        String string = "";
        if (this.m_urls != null) {
            int n = 0;
            while (n < this.m_urls.length) {
                if (n != 0) {
                    string = String.valueOf(string) + ",";
                }
                string = String.valueOf(string) + this.m_urls[n];
                ++n;
            }
        }
        return "SearchResultReference " + string;
    }
}

